/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.test.fileupload;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.fileupload.core.SingleFileUpload;
import org.sysolar.fileupload.core.UploadCheckerImpl;
import org.sysolar.fileupload.ex.ContentTypeException;
import org.sysolar.fileupload.ex.FileExtendException;
import org.sysolar.fileupload.ex.FileSizeException;
import org.sysolar.fileupload.ex.NullFileException;
import org.sysolar.sun.mvc.support.RequestWrapper;

public final class SingleFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SingleFileUploadServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestWrapper wrapper = new RequestWrapper((ServletRequest)request);
        request.setCharacterEncoding(super.getInitParameter("CHAR_ENCODING"));
        double maxFileSize = Double.parseDouble(super.getInitParameter("MAX_FILE_SIZE"));
        maxFileSize = maxFileSize * 1024.0 * 1024.0 + 1000.0;
        String invalidFileExtend = super.getInitParameter("INVALID_FILE_EXTEND");
        String saveDir = super.getInitParameter("FILE_PATH");
        try {
            UploadCheckerImpl checker = new UploadCheckerImpl(maxFileSize, null, invalidFileExtend);
            new SingleFileUpload(request).parseRequest(saveDir, null, checker);
            String[] userNames = wrapper.getStringValues("userName");
            int i = 0;
            while (userNames != null && i < userNames.length) {
                System.out.printf("userName[%d]=%s%n", i, userNames[i]);
                ++i;
            }
        }
        catch (ContentTypeException ex) {
            request.setAttribute("ERROR", (Object)"form \u8868\u5355\u7684 enctype \u5c5e\u6027\u503c\u8bbe\u7f6e\u9519\u8bef\uff01\u8bf7\u8bbe\u4e3a multipart/form-data \uff01");
        }
        catch (NullFileException ex) {
            request.setAttribute("ERROR", (Object)"\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6 \uff01");
        }
        catch (FileSizeException ex) {
            request.setAttribute("ERROR", (Object)(String.valueOf(ex.getFileName()) + " \u7684\u5927\u5c0f\u5e94\u5c0f\u4e8e " + maxFileSize + "M \uff01"));
        }
        catch (FileExtendException ex) {
            request.setAttribute("ERROR", (Object)(String.valueOf(ex.getFileName()) + " \u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e \uff01"));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.getServletContext().getRequestDispatcher("/FileUpload/SingleFileUpload.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

