/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.mvc.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

public final class RequestWrapper {
    private static final SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ServletRequest request;

    public RequestWrapper(ServletRequest request) {
        this.request = request;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(ServletRequest request) {
        this.request = request;
    }

    public Integer getInt(String paramName) throws Exception {
        return this.getInteger(paramName);
    }

    public Integer getInteger(String paramName) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : Integer.valueOf(paramValue);
    }

    public Integer[] getIntValues(String paramName) throws Exception {
        String[] strValues = this.getStringValues(paramName);
        Integer[] iValues = new Integer[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            iValues[i] = "".equals(strValues[i]) ? null : Integer.valueOf(strValues[i]);
            ++i;
        }
        return iValues;
    }

    public Long getLong(String paramName) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : Long.valueOf(paramValue);
    }

    public Long[] getLongValues(String paramName) throws Exception {
        String[] strValues = this.getStringValues(paramName);
        Long[] lValues = new Long[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            lValues[i] = "".equals(strValues[i]) ? null : Long.valueOf(strValues[i]);
            ++i;
        }
        return lValues;
    }

    public Double getDouble(String paramName) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : Double.valueOf(paramValue);
    }

    public Double[] getDoubleValues(String paramName) throws Exception {
        String[] strValues = this.getStringValues(paramName);
        Double[] dValues = new Double[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            dValues[i] = "".equals(strValues[i]) ? null : Double.valueOf(strValues[i]);
            ++i;
        }
        return dValues;
    }

    public Float getFloat(String paramName) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : Float.valueOf(paramValue);
    }

    public Float[] getFloatValues(String paramName) throws Exception {
        String[] strValues = this.getStringValues(paramName);
        Float[] fValues = new Float[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            fValues[i] = "".equals(strValues[i]) ? null : Float.valueOf(strValues[i]);
            ++i;
        }
        return fValues;
    }

    public String getString(String paramName) {
        if (this.request.getParameter(paramName) != null) {
            return this.request.getParameter(paramName);
        }
        List valueList = (List)this.request.getAttribute(paramName);
        if (valueList != null) {
            return (String)valueList.get(0);
        }
        return null;
    }

    public String[] getStringValues(String paramName) {
        if (this.request.getParameterValues(paramName) != null) {
            return this.request.getParameterValues(paramName);
        }
        List valueList = (List)this.request.getAttribute(paramName);
        if (valueList != null) {
            String[] valueArray = new String[valueList.size()];
            valueList.toArray(valueArray);
            return valueArray;
        }
        return null;
    }

    public Date getDate(String paramName) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : dtFormat.parse(paramValue);
    }

    public Date getDate(String paramName, String pattern) throws Exception {
        String paramValue = this.request.getParameter(paramName);
        return paramValue == null || "".equals(paramValue) ? null : new SimpleDateFormat(pattern).parse(paramValue);
    }

    public Date getYearMonthDay() throws Exception {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getString("year")).append(this.getString("month")).append(this.getString("day"));
        return dFormat.parse(sb.toString());
    }

    public Integer getPageNum() throws Exception {
        String paramValue = this.request.getParameter("pageNum");
        return paramValue == null || "".equals(paramValue) ? null : Integer.valueOf(paramValue);
    }

    public Integer getPageSize() throws Exception {
        String paramValue = this.request.getParameter("pageSize");
        return paramValue == null || "".equals(paramValue) ? null : Integer.valueOf(paramValue);
    }

    public String getDispatch() {
        return this.request.getParameter("dispatch");
    }

    public Long getTimestamp() throws Exception {
        return this.getLong("timestamp");
    }

    public String toString() {
        String separator = ", ";
        int lastIndex = -1;
        StringBuilder sb = new StringBuilder(500).append("{");
        Map paramMap = this.request.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=[");
            String[] stringArray = (String[])entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                sb.append(value).append(separator);
                ++n2;
            }
            lastIndex = sb.lastIndexOf(separator);
            if (lastIndex >= 0) {
                sb.delete(lastIndex, sb.length());
            }
            sb.append("]").append(separator);
        }
        lastIndex = sb.lastIndexOf(separator);
        if (lastIndex >= 0) {
            sb.delete(lastIndex, sb.length());
        }
        sb.append("}");
        return sb.toString();
    }
}

