/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.mvc.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Json {
    private static Pattern pKvPair = Pattern.compile("(\\w+):([@#]?[\\-\\d\\.]+|'[^']*')");
    private static Pattern pJson = Pattern.compile("\\{(\\w+:([@#]?[\\-\\d\\.]+|'[^']*'),?)*\\}");
    private static Pattern pJsonArrayElement = Pattern.compile("[@#]?[\\-\\d\\.]+|'[^']*'");
    private static Pattern pJsonArray = Pattern.compile("\\[(([@#]?[\\-\\d\\.]+|'[^']*'),?)*\\]");
    private static Pattern pMapReplacer = Pattern.compile("@\\d+");
    private static Pattern pListReplacer = Pattern.compile("#\\d+");

    public static String toJs(String key, Map<?, ?> map) {
        StringBuilder buffer = new StringBuilder(512);
        Json.toJsPrifix(buffer, key);
        Json.encode(buffer, map);
        Json.toJsSuffix(buffer);
        return buffer.toString();
    }

    public static String toJs(String key, Object[] values) {
        StringBuilder buffer = new StringBuilder(4096);
        Json.toJsPrifix(buffer, key);
        Json.encode(buffer, values);
        Json.toJsSuffix(buffer);
        return buffer.toString();
    }

    public static String toJs(String key, List<?> list) {
        return Json.toJs(key, list.toArray());
    }

    public static String toJs(String key, Object obj) {
        StringBuilder buffer = new StringBuilder(128);
        Json.toJsPrifix(buffer, key);
        Json.encode(buffer, obj);
        Json.toJsSuffix(buffer);
        return buffer.toString();
    }

    private static void toJsPrifix(StringBuilder buffer, String key) {
        buffer.append("DB.put('");
        buffer.append(key);
        buffer.append("',");
    }

    private static void toJsSuffix(StringBuilder buffer) {
        buffer.append(");");
    }

    public static String toScript(String jsMethod, Object ... params) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("<script>");
        buffer.append("parent.").append(jsMethod).append("(");
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            Json.encode(buffer, param);
            buffer.append(",");
            ++n2;
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(");");
        buffer.append("</script>");
        return buffer.toString();
    }

    public static String encode(Map<?, ?> map) {
        StringBuilder buffer = new StringBuilder(512);
        Json.encode(buffer, map);
        return buffer.toString();
    }

    public static void encode(StringBuilder buffer, Map<?, ?> map) {
        buffer.append("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            buffer.append("'").append(entry.getKey()).append("':");
            Object value = entry.getValue();
            Json.encode(buffer, value);
            buffer.append(",");
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("}");
    }

    public static String encode(List<?> list) {
        return Json.encode(list.toArray());
    }

    public static void encode(StringBuilder buffer, List<?> list) {
        Json.encode(buffer, list.toArray());
    }

    public static String encode(Object[] values) {
        StringBuilder buffer = new StringBuilder(4096);
        Json.encode(buffer, values);
        return buffer.toString();
    }

    public static void encode(StringBuilder buffer, Object[] values) {
        buffer.append("[");
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            Json.encode(buffer, value);
            buffer.append(",");
            ++n2;
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("]");
    }

    public static String encode(Object value) {
        StringBuilder buffer = new StringBuilder(128);
        Json.encode(buffer, value);
        return buffer.toString();
    }

    public static void encode(StringBuilder buffer, Object value) {
        if (value instanceof String) {
            buffer.append("'").append(value).append("'");
        } else if (value instanceof Date) {
            buffer.append(((Date)value).getTime());
        } else {
            buffer.append(value);
        }
    }

    public static Map<String, Object> toJavaMap(String json) {
        return (Map)Json.toJavaObject(json);
    }

    public static List<Object> toJavaList(String json) {
        return (List)Json.toJavaObject(json);
    }

    public static Object toJavaObject(String input) {
        boolean found;
        input = input.trim();
        Matcher mKvPair = null;
        Matcher mJson = null;
        Matcher mJsonArrayElement = null;
        Matcher mJsonArray = null;
        StringBuilder buffer = new StringBuilder(input);
        int offset = 0;
        ArrayList mapList = new ArrayList(100);
        ArrayList listList = new ArrayList(100);
        do {
            String replacer;
            if (pMapReplacer.matcher(input).matches()) {
                return mapList.get(mapList.size() - 1);
            }
            if (pListReplacer.matcher(input).matches()) {
                return listList.get(listList.size() - 1);
            }
            found = false;
            offset = 0;
            mJson = pJson.matcher(input);
            while (mJson.find()) {
                found = true;
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                mKvPair = pKvPair.matcher(mJson.group());
                while (mKvPair.find()) {
                    String key = mKvPair.group(1);
                    String value = mKvPair.group(2);
                    if (pMapReplacer.matcher(value).matches()) {
                        map.put(key, mapList.get(Integer.parseInt(value.substring(1))));
                        continue;
                    }
                    if (pListReplacer.matcher(value).matches()) {
                        map.put(key, listList.get(Integer.parseInt(value.substring(1))));
                        continue;
                    }
                    if (value.charAt(0) == '\'') {
                        map.put(key, value.substring(1, value.length() - 1));
                        continue;
                    }
                    map.put(key, value);
                }
                replacer = "@" + mapList.size();
                buffer.replace(mJson.start() - offset, mJson.end() - offset, replacer);
                offset += mJson.end() - mJson.start() - replacer.length();
                mapList.add(map);
            }
            input = buffer.toString();
            offset = 0;
            mJsonArray = pJsonArray.matcher(input);
            while (mJsonArray.find()) {
                found = true;
                ArrayList list = new ArrayList(20);
                mJsonArrayElement = pJsonArrayElement.matcher(mJsonArray.group());
                while (mJsonArrayElement.find()) {
                    String element = mJsonArrayElement.group();
                    if (pMapReplacer.matcher(element).matches()) {
                        list.add(mapList.get(Integer.parseInt(element.substring(1))));
                        continue;
                    }
                    if (pListReplacer.matcher(element).matches()) {
                        list.add(listList.get(Integer.parseInt(element.substring(1))));
                        continue;
                    }
                    if (element.charAt(0) == '\'') {
                        list.add(element.substring(1, element.length() - 1));
                        continue;
                    }
                    list.add(element);
                }
                replacer = "#" + listList.size();
                buffer.replace(mJsonArray.start() - offset, mJsonArray.end() - offset, replacer);
                offset += mJsonArray.end() - mJsonArray.start() - replacer.length();
                listList.add(list);
            }
            input = buffer.toString();
        } while (found);
        return null;
    }

    public static String format(String json) {
        String s;
        json = json.replaceAll("\\\\\"", "").replaceAll("\\\\'", "").replaceAll("\\s+", "");
        int offset = 0;
        StringBuilder buffer = new StringBuilder(json);
        Pattern p = Pattern.compile("\"[^\"\\d]+\\,[^\"\\d]+\"");
        Matcher m = p.matcher(json);
        while (m.find()) {
            s = m.group().replace(',', ' ');
            buffer.replace(m.start(), m.end(), "\"" + s.substring(1, s.length() - 1) + "\"");
        }
        json = buffer.toString();
        p = Pattern.compile("\"([^,]*[\"'\\[\\]\\{\\}]+)+[^,]*\"");
        m = p.matcher(json);
        while (m.find()) {
            s = m.group().replace('\"', ' ').replace('[', ' ').replace(']', ' ').replace('{', ' ').replace('}', ' ');
            buffer.replace(m.start(), m.end(), "\"" + s.substring(1, s.length() - 1) + "\"");
        }
        json = buffer.toString();
        p = Pattern.compile("'([^,]*['\"\\[\\]\\{\\}]+)+[^,]*'");
        m = p.matcher(json);
        while (m.find()) {
            s = m.group().replace('\'', ' ').replace('\"', ' ');
            buffer.replace(m.start(), m.end(), "'" + s.substring(1, s.length() - 1) + "'");
        }
        json = buffer.toString();
        json = json.replace('\"', '\'');
        json = json.replaceAll("\\s*:\\s*", ":");
        json = json.replaceAll("\\s*,\\s*", ",");
        json = json.replaceAll("\\s*\\[", "[").replaceAll("\\s*\\]", "]").replaceAll("\\s*\\{", "{").replaceAll("\\s*\\}", "}");
        p = Pattern.compile("'(\\w+)':");
        m = p.matcher(json);
        buffer.delete(0, buffer.length()).append(json);
        while (m.find()) {
            buffer.deleteCharAt(m.start() - offset);
            buffer.deleteCharAt(m.end() - 2 - ++offset);
            ++offset;
        }
        p = Pattern.compile(":([a-zA-Z_]+)([,\\]\\}])");
        m = p.matcher(buffer.toString());
        offset = 0;
        while (m.find()) {
            buffer.insert(m.start() + 1 + offset, '\'');
            buffer.insert(m.end() - 1 + ++offset, '\'');
            ++offset;
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("aaa", 1);
        map.put("bbb", 2);
        System.out.println(Json.encode(map));
    }
}

