/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.jdbc.core.JdbcOperationsAbstract;
import org.sysolar.sun.jdbc.core.Transactions;
import org.sysolar.sun.jdbc.support.DBHelper;

public class JdbcOperationsOracleImpl
extends JdbcOperationsAbstract {
    public JdbcOperationsOracleImpl(String logName) {
        super(logName);
    }

    @Override
    public List<Map<String, Object>> callForList(Connection conn, String procName, Object ... params) throws SQLException {
        List<Map<String, Object>> list;
        ArrayList<Map<String, Object>> list2 = new ArrayList<Map<String, Object>>();
        String sql = this.buildInOutSql(procName, params.length, 1);
        if (this.DEBUG) {
            this.log.debug((Object)this.buildString(sql, params));
        }
        CallableStatement cstmt = null;
        ResultSet rs = null;
        try {
            if (conn == null) {
                conn = Transactions.getConnection();
            }
            cstmt = conn.prepareCall(sql);
            this.setParameters(cstmt, params);
            cstmt.registerOutParameter(params.length + 1, -10);
            cstmt.execute();
            rs = (ResultSet)cstmt.getObject(params.length + 1);
            list = this.extractData(rs, list2);
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)this.buildString(sql, params), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBHelper.close(cstmt, rs);
                throw throwable;
            }
        }
        DBHelper.close(cstmt, rs);
        return list;
    }

    @Override
    public List<Map<String, Object>> callForList(String procName, Object ... params) throws SQLException {
        return this.callForList(null, procName, params);
    }
}

