/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.core;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.jdbc.core.JdbcOperations;
import org.sysolar.sun.jdbc.core.Transactions;
import org.sysolar.sun.jdbc.support.DBHelper;
import org.sysolar.sun.jdbc.support.NullType;
import org.sysolar.util.Constants;

public abstract class JdbcOperationsAbstract
implements JdbcOperations {
    protected Log log;
    protected boolean DEBUG;
    protected boolean INFO;

    public JdbcOperationsAbstract(String logName) {
        this.log = LogFactory.getLog((String)logName);
        this.DEBUG = this.log.isDebugEnabled();
        this.INFO = this.log.isInfoEnabled();
    }

    @Override
    public int update(String sql, Object ... params) throws SQLException {
        return this.update(null, sql, params);
    }

    @Override
    public void update(String sql, List<Object[]> params) throws SQLException {
        this.update(null, sql, params);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... params) throws SQLException {
        return this.queryForList(null, sql, params);
    }

    @Override
    public Object queryForObject(String sql, Object ... params) throws SQLException {
        return this.queryForObject(null, sql, params);
    }

    @Override
    public String queryForString(String sql, Object ... params) throws SQLException {
        return this.queryForString(null, sql, params);
    }

    @Override
    public Number queryForNumber(String sql, Object ... params) throws SQLException {
        return this.queryForNumber(null, sql, params);
    }

    @Override
    public int queryForInt(String sql, Object ... params) throws SQLException {
        return this.queryForInt(null, sql, params);
    }

    @Override
    public long queryForLong(String sql, Object ... params) throws SQLException {
        return this.queryForNumber(sql, params).longValue();
    }

    @Override
    public void call(String procName, Object ... params) throws SQLException {
        this.call(null, procName, params);
    }

    @Override
    public Number callForNumber(String procName, Object ... params) throws SQLException {
        return this.callForNumber(null, procName, params);
    }

    @Override
    public String callForString(String procName, Object ... params) throws SQLException {
        return this.callForString(null, procName, params);
    }

    @Override
    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        if (params.length == 0) {
            return this.update(conn, sql);
        }
        StringBuilder buffer = null;
        long beginTime = -1L;
        if (this.INFO) {
            buffer = new StringBuilder(1024);
            buffer.append(this.buildString(sql, params)).append(Constants.LS);
            beginTime = System.currentTimeMillis();
        }
        int affectedRow = -1;
        PreparedStatement pstmt = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                pstmt = conn.prepareStatement(sql);
                this.setParameters(pstmt, params);
                affectedRow = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, affectedRow, params), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(pstmt);
            throw throwable;
        }
        DBHelper.close(pstmt);
        if (this.INFO) {
            buffer.append("::: sql num : ").append(affectedRow).append(", exec time : ").append((double)(System.currentTimeMillis() - beginTime) / 1000.0).append(" s").append(Constants.LS);
            this.log.info((Object)buffer.toString());
        }
        return affectedRow;
    }

    private int update(Connection conn, String sql) throws SQLException {
        StringBuilder buffer = null;
        long beginTime = -1L;
        if (this.INFO) {
            buffer = new StringBuilder(1024).append(Constants.LS);
            buffer.append(sql).append(Constants.LS);
            beginTime = System.currentTimeMillis();
        }
        int affectedRow = -1;
        Statement stmt = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                stmt = conn.createStatement();
                affectedRow = stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, affectedRow, new Object[0]), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt);
            throw throwable;
        }
        DBHelper.close(stmt);
        if (this.INFO) {
            buffer.append("::: sql num : ").append(affectedRow).append(", exec time : ").append((double)(System.currentTimeMillis() - beginTime) / 1000.0).append(" s").append(Constants.LS);
            this.log.info((Object)buffer.toString());
        }
        return affectedRow;
    }

    @Override
    public void update(Connection conn, String sql, List<Object[]> params) throws SQLException {
        StringBuilder buffer = null;
        long beginTime = -1L;
        if (this.INFO) {
            buffer = new StringBuilder(1024).append(Constants.LS);
            buffer.append(sql).append(Constants.LS);
            beginTime = System.currentTimeMillis();
        }
        int i = 0;
        int paramSize = params.size();
        PreparedStatement pstmt = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                pstmt = conn.prepareStatement(sql);
                i = 0;
                while (i < paramSize) {
                    this.setParameters(pstmt, params.get(i));
                    pstmt.addBatch();
                    if (i > 0 && i % 10001 == 0 || i == paramSize - 1) {
                        int[] results = pstmt.executeBatch();
                        if (this.DEBUG) {
                            int j = 0;
                            while (j < results.length) {
                                buffer.append(this.buildString(results[j], params.get(i + 1 - results.length + j)));
                                ++j;
                            }
                        }
                        if (this.INFO) {
                            buffer.append("::: sql num : ").append(results.length).append(", exec time : ").append((double)(System.currentTimeMillis() - beginTime) / 1000.0).append(" s").append(Constants.LS);
                            beginTime = System.currentTimeMillis();
                        }
                    }
                    ++i;
                }
                if (this.INFO) {
                    this.log.info((Object)buffer.toString());
                }
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, -1, params.get(i)), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(pstmt);
            throw throwable;
        }
        DBHelper.close(pstmt);
    }

    @Override
    public List<Map<String, Object>> queryForList(Connection conn, String sql, Object ... params) throws SQLException {
        if (params == null || params.length == 0) {
            return this.queryForList(conn, sql);
        }
        StringBuilder buffer = null;
        long beginTime = -1L;
        if (this.INFO) {
            buffer = new StringBuilder(1024);
            buffer.append(this.buildString(sql, params)).append(Constants.LS);
            beginTime = System.currentTimeMillis();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                pstmt = conn.prepareStatement(sql);
                this.setParameters(pstmt, params);
                rs = pstmt.executeQuery();
                this.extractData(rs, list);
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, -1, params), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(pstmt, rs);
            throw throwable;
        }
        DBHelper.close(pstmt, rs);
        if (this.INFO) {
            buffer.append("::: sql num : ").append(list.size()).append(", exec time : ").append((double)(System.currentTimeMillis() - beginTime) / 1000.0).append(" s").append(Constants.LS);
            this.log.info((Object)buffer.toString());
        }
        return list;
    }

    private List<Map<String, Object>> queryForList(Connection conn, String sql) throws SQLException {
        StringBuilder buffer = null;
        long beginTime = -1L;
        if (this.INFO) {
            buffer = new StringBuilder(1024).append(Constants.LS);
            buffer.append(sql).append(Constants.LS);
            beginTime = System.currentTimeMillis();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                this.extractData(rs, list);
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, -1, new Object[0]), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(stmt, rs);
            throw throwable;
        }
        DBHelper.close(stmt, rs);
        if (this.INFO) {
            buffer.append("::: sql num : ").append(list.size()).append(", exec time : ").append((double)(System.currentTimeMillis() - beginTime) / 1000.0).append(" s").append(Constants.LS);
            this.log.info((Object)buffer.toString());
        }
        return list;
    }

    @Override
    public Object queryForObject(Connection conn, String sql, Object ... params) throws SQLException {
        List<Map<String, Object>> list = this.queryForList(conn, sql, params);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).values().iterator().next();
    }

    @Override
    public Number queryForNumber(Connection conn, String sql, Object ... params) throws SQLException {
        Object obj = this.queryForObject(conn, sql, params);
        if (obj != null) {
            return (Number)obj;
        }
        return new Integer(-1);
    }

    @Override
    public int queryForInt(Connection conn, String sql, Object ... params) throws SQLException {
        return this.queryForNumber(conn, sql, params).intValue();
    }

    @Override
    public String queryForString(Connection conn, String sql, Object ... params) throws SQLException {
        return (String)this.queryForObject(conn, sql, params);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return Transactions.getConnection();
    }

    protected void setParameters(PreparedStatement pstmt, Object ... params) throws SQLException {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            Comparable<Long> obj;
            if (params[i] == null) {
                pstmt.setNull(i + 1, 0);
            } else if (params[i] instanceof NullType) {
                switch ((NullType)((Object)params[i])) {
                    case INTEGER: {
                        pstmt.setNull(i + 1, 4);
                        break;
                    }
                    case VARCHAR: {
                        pstmt.setNull(i + 1, 12);
                        break;
                    }
                    case TIMESTAMP: {
                        pstmt.setNull(i + 1, 93);
                    }
                }
            } else if (params[i] instanceof Long) {
                obj = (Long)params[i];
                pstmt.setLong(i + 1, (Long)obj);
            } else if (params[i] instanceof String) {
                String str = (String)params[i];
                if (str.length() < 16000) {
                    pstmt.setString(i + 1, str);
                } else {
                    pstmt.setCharacterStream(i + 1, (Reader)new StringReader(str), str.length());
                }
            } else if (params[i] instanceof Integer) {
                obj = (Integer)params[i];
                pstmt.setInt(i + 1, (Integer)obj);
            } else if (params[i] instanceof Character) {
                obj = (Character)params[i];
                pstmt.setString(i + 1, ((Character)obj).toString());
            } else if (params[i] instanceof Float) {
                obj = (Float)params[i];
                pstmt.setFloat(i + 1, ((Float)obj).floatValue());
            } else if (params[i] instanceof Double) {
                obj = (Double)params[i];
                pstmt.setDouble(i + 1, (Double)obj);
            } else if (params[i] instanceof java.util.Date) {
                obj = (java.util.Date)params[i];
                pstmt.setTimestamp(i + 1, new Timestamp(((java.util.Date)obj).getTime()));
            } else if (params[i] instanceof Date) {
                obj = (Date)params[i];
                pstmt.setDate(i + 1, (Date)obj);
            } else {
                pstmt.setObject(i + 1, params[i]);
            }
            ++i;
        }
    }

    protected List<Map<String, Object>> extractData(ResultSet rs, List<Map<String, Object>> list) throws SQLException {
        ResultSetMetaData rsmd = null;
        rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        HashMap<String, Object> map = null;
        Object obj = null;
        int sqlType = 0;
        while (rs.next()) {
            map = new HashMap<String, Object>(32);
            int i = 1;
            while (i <= numberOfColumns) {
                Clob clob;
                sqlType = rsmd.getColumnType(i);
                obj = sqlType == 91 ? rs.getTimestamp(i) : (sqlType == 2005 ? ((clob = rs.getClob(i)) != null ? clob.getSubString(1L, (int)clob.length()) : null) : rs.getObject(i));
                map.put(rsmd.getColumnName(i).toUpperCase(), obj);
                ++i;
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public void call(Connection conn, String procName, Object ... params) throws SQLException {
        String sql = this.buildInSql(procName, params.length);
        if (this.DEBUG) {
            this.log.debug((Object)this.buildString(sql, params));
        }
        CallableStatement cstmt = null;
        try {
            try {
                if (conn == null) {
                    conn = Transactions.getConnection();
                }
                cstmt = conn.prepareCall(sql);
                this.setParameters(cstmt, params);
                cstmt.execute();
            }
            catch (SQLException e) {
                this.log.error((Object)this.buildString(sql, params), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBHelper.close(cstmt);
            throw throwable;
        }
        DBHelper.close(cstmt);
    }

    @Override
    public Number callForNumber(Connection conn, String procName, Object ... params) throws SQLException {
        Object obj = this.callForObject(conn, procName, 2, params);
        if (obj == null) {
            return new Integer(-1);
        }
        return (Number)obj;
    }

    @Override
    public String callForString(Connection conn, String procName, Object ... params) throws SQLException {
        return (String)this.callForObject(conn, procName, 12, params);
    }

    private Object callForObject(Connection conn, String procName, int sqlType, Object ... params) throws SQLException {
        Object object;
        String sql = this.buildInOutSql(procName, params.length, 1);
        if (this.DEBUG) {
            this.log.debug((Object)this.buildString(sql, params));
        }
        CallableStatement cstmt = null;
        try {
            if (conn == null) {
                conn = Transactions.getConnection();
            }
            cstmt = conn.prepareCall(sql);
            this.setParameters(cstmt, params);
            cstmt.registerOutParameter(params.length + 1, sqlType);
            cstmt.execute();
            object = cstmt.getObject(params.length + 1);
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)this.buildString(sql, params), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DBHelper.close(cstmt);
                throw throwable;
            }
        }
        DBHelper.close(cstmt);
        return object;
    }

    private String buildSql(String procName, int inParamsLength, int outParamsLength) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("{call ").append(procName).append("(");
        if (inParamsLength >= 1) {
            sql.append("?");
        }
        int i = 2;
        while (i <= inParamsLength) {
            sql.append(" ,?");
            ++i;
        }
        if (inParamsLength >= 1) {
            i = 1;
            while (i <= outParamsLength) {
                sql.append(" ,?");
                ++i;
            }
        } else {
            if (outParamsLength >= 1) {
                sql.append("?");
            }
            i = 2;
            while (i <= outParamsLength) {
                sql.append(" ,?");
                ++i;
            }
        }
        sql.append(")}");
        return sql.toString();
    }

    protected String buildInSql(String procName, int inParamsLength) {
        return this.buildSql(procName, inParamsLength, 0);
    }

    protected String buildInOutSql(String procName, int inParamsLength, int outParamsLength) {
        return this.buildSql(procName, inParamsLength, outParamsLength);
    }

    protected String buildString(int affectedRow, Object ... params) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(Constants.BLANK_4).append("{affectedRow:").append(affectedRow).append(", params:[");
        int i = 0;
        while (i < params.length) {
            if (params[i] instanceof java.util.Date) {
                buffer.append(String.format("%1$tF %1$tT %1$tL", (java.util.Date)params[i]));
            } else {
                buffer.append(params[i]);
            }
            buffer.append(", ");
            ++i;
        }
        if (params.length > 0) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        return buffer.append("]}").append(Constants.LS).toString();
    }

    protected String buildString(String sql, int affectedRow, Object ... params) {
        StringBuilder buffer = new StringBuilder(2048).append(Constants.LS);
        buffer.append(sql).append(Constants.LS);
        buffer.append(this.buildString(affectedRow, params));
        return buffer.toString();
    }

    protected String buildString(String sql, Object ... params) {
        StringBuilder buffer = new StringBuilder(1024).append(Constants.LS);
        buffer.append(sql).append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("params:[");
        int i = 0;
        while (i < params.length) {
            if (params[i] instanceof java.util.Date) {
                buffer.append(String.format("%1$tF %1$tT %1$tL", (java.util.Date)params[i]));
            } else {
                buffer.append(params[i]);
            }
            buffer.append(", ");
            ++i;
        }
        if (params.length > 0) {
            buffer.delete(buffer.length() - 2, buffer.length());
        }
        return buffer.append("]").toString();
    }
}

