/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.jdbc.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.support.DatabaseTypes;

public class DataSourceFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);
    private static Map<String, DataSource> dsMap = new HashMap<String, DataSource>();

    private static DataSource initDataSource(String name) {
        DataSource dataSource = null;
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:comp/env");
            dataSource = (DataSource)envContext.lookup(name);
            log.info((Object)("name=" + name + "; dataSource=" + dataSource));
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
        return dataSource;
    }

    public static DataSource getDataSource(String dataSourceName) {
        DataSource dataSource = dsMap.get(dataSourceName);
        if (dataSource == null) {
            if (AppContext.getDatabaseType() == DatabaseTypes.DERBY) {
                String dbName = new File(new File(AppContext.getAppRoot(), "db"), AppContext.getValue("dbName")).getAbsolutePath();
                String url = "jdbc:derby:" + dbName + ";create=true";
                BasicDataSource ds = new BasicDataSource();
                ds.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
                ds.setUrl(url);
                if (AppContext.getValue("maxActive") != null) {
                    ds.setMaxActive(AppContext.getInt("maxActive").intValue());
                } else {
                    ds.setMaxActive(12);
                }
                if (AppContext.getValue("maxIdle") != null) {
                    ds.setMaxActive(AppContext.getInt("maxIdle").intValue());
                } else {
                    ds.setMaxActive(3);
                }
                dataSource = ds;
            } else {
                dataSource = DataSourceFactory.initDataSource(dataSourceName);
            }
            dsMap.put(dataSourceName, dataSource);
        }
        return dataSource;
    }
}

