/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.config;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.util.Constants;
import org.sysolar.util.file.FileIO;

public class FileConfig {
    private static Log log = LogFactory.getLog(FileConfig.class);
    private static String filePath = null;
    private static String CHARSET = "UTF-8";
    private static final Map<String, String> prop = Collections.synchronizedMap(new LinkedHashMap(36));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String path) {
        if (path != null) {
            filePath = path;
        }
        File configFile = new File(filePath);
        Pattern p = Pattern.compile("\\s*[=:]\\s*");
        Map<String, String> map = prop;
        synchronized (map) {
            prop.clear();
            if (!configFile.exists()) {
                log.error((Object)("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath));
            }
            List<String> list = FileIO.readAsList(configFile, CHARSET);
            for (String config : list) {
                if ((config = config.trim()).equals("") || config.charAt(0) == '#') continue;
                String[] arr = p.split(config, 2);
                if (arr.length == 1) {
                    prop.put(arr[0], null);
                    continue;
                }
                if (arr.length != 2) continue;
                prop.put(arr[0], arr[1]);
            }
        }
    }

    public static void reload() {
        FileConfig.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        StringBuilder buffer = new StringBuilder(8192);
        buffer.append("########## \u914d\u7f6e\u6587\u4ef6 KEY-VALUE \u683c\u5f0f ##########").append(Constants.LS);
        Map<String, String> map = prop;
        synchronized (map) {
            for (Map.Entry<String, String> entry : prop.entrySet()) {
                buffer.append(entry.getKey()).append("=").append(entry.getValue()).append(Constants.LS);
            }
            FileIO.writeToFile(filePath, buffer.toString(), false, CHARSET);
        }
    }

    public static String getString(String key) {
        return prop.get(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = FileConfig.getString(key);
        return value != null ? value : defaultValue;
    }

    public static Integer getInteger(String key) {
        return FileConfig.getInteger(key, null);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        String value = FileConfig.getString(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    public static Boolean getBoolean(String key) {
        String value = FileConfig.getString(key);
        return value != null ? Boolean.valueOf(value) : null;
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        String value = FileConfig.getString(key);
        if (value == null || value.trim().equals("")) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Double getDouble(String key, Double defaultValue) {
        String value = FileConfig.getString(key);
        if (value == null || value.trim().equals("")) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public static Double getDouble(String key) {
        return FileConfig.getDouble(key, null);
    }

    public static Map<String, Object> getMap(String key) {
        String value = FileConfig.getString(key);
        return value != null ? Json.toJavaMap(value) : null;
    }

    public static List<Object> getList(String key) {
        String value = FileConfig.getString(key);
        return value != null ? Json.toJavaList(value) : null;
    }

    public static void setString(String key, String value) {
        FileConfig.setString(key, value, true);
    }

    public static void setString(String key, String value, boolean saveToFile) {
        prop.put(key, value);
        if (saveToFile) {
            FileConfig.save();
        }
    }

    public static void setInteger(String key, Integer value) {
        FileConfig.setString(key, String.valueOf(value));
    }

    public static void setMap(String key, Map<String, Object> value) {
        FileConfig.setString(key, Json.encode(value));
    }

    public static Map<String, String> getConfig() {
        return Collections.unmodifiableMap(prop);
    }

    public static void main(String[] args) {
        FileConfig.load("E:\\temp\\temp.txt");
        System.out.println(FileConfig.getMap("clientKey"));
        FileConfig.save();
    }
}

