/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.sun.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sysolar.sun.cache.Cache;

public class CacheList<E>
extends Cache
implements List<E> {
    private List<E> list = null;

    public CacheList(int cacheInterval) {
        this(cacheInterval, null);
    }

    public CacheList(int cacheInterval, Integer cacheSize) {
        this.cacheInterval = cacheInterval;
        if (cacheSize == null) {
            this.list = Collections.synchronizedList(new ArrayList(100));
        } else {
            this.list = Collections.synchronizedList(new ArrayList(cacheSize));
            this.cacheSize = cacheSize;
        }
    }

    @Override
    public void clear() {
        this.list.clear();
        this.cacheBeginTime = System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() - this.cacheBeginTime >= (long)this.cacheInterval || this.cacheSize != null && this.list.size() > this.cacheSize;
    }

    public List<E> getList() {
        return this.list;
    }

    @Override
    public boolean add(E o) {
        return this.list.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

