/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.war;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import org.sysolar.util.Constants;
import org.sysolar.util.file.FileIO;

public class BuilderWarPack {
    private static Process process;
    private static boolean debug;
    private static String encode;

    static {
        debug = false;
        encode = "utf-8";
    }

    public static void main(String[] args) throws IOException {
        BuilderWarPack.execDo();
    }

    public static void execDo() throws IOException {
        String[] setting = BuilderWarPack.loadDefaults();
        BuilderWarPack.execJsFilesToMerge(setting[0], "\u6b65\u9aa41:JS\u6587\u4ef6\u5408\u5e76");
        BuilderWarPack.execYuiCompression(setting[0], "\u6b65\u9aa42:JS&CSS\u6587\u4ef6\u5904\u7406");
        BuilderWarPack.execFileCompression(setting[0], "\u6b65\u9aa43:JSP\u6587\u4ef6\u5904\u7406");
        BuilderWarPack.execCMD(setting[0], setting[1], "\u6b65\u9aa44:\u6253\u5305\u538b\u7f29");
    }

    private static String[] loadDefaults() throws IOException {
        Properties defaults = new Properties();
        FileInputStream input = new FileInputStream(String.valueOf(Constants.ROOT_PATH) + "\\default.properties");
        defaults.load(input);
        input.close();
        debug = "true".equals(defaults.getProperty("debug").trim());
        encode = defaults.getProperty("encode").trim();
        return new String[]{defaults.getProperty("srcPath").trim(), defaults.getProperty("destPath").trim()};
    }

    private static void execJsFilesToMerge(String srcPath, String logInfo) {
        List<File> fileList = FileIO.listFilesInDirSubdirs(new File(srcPath));
        if (debug) {
            System.out.println(new StringBuilder(logInfo).append(" START>>>"));
        }
        for (File file : fileList) {
            boolean isJsFile;
            String fileName = file.getName();
            String suffixFileName = fileName.substring(fileName.lastIndexOf(".") + 1);
            boolean bl = isJsFile = "js".equals(suffixFileName) && fileName.startsWith("_");
            if (!isJsFile) continue;
            List<String> jsFileList = FileIO.readAsList(file, encode);
            StringBuilder sbContent = new StringBuilder();
            for (String js : jsFileList) {
                if (js.indexOf("Loader.loadJs('") <= -1) continue;
                File mfile = new File(String.valueOf(srcPath) + "\\" + js.substring(js.indexOf("'") + 1, js.lastIndexOf("'")));
                sbContent.append(FileIO.readAsString(mfile, encode));
                mfile.delete();
            }
            FileIO.writeToFile(file.getAbsolutePath(), sbContent.toString(), false, encode);
            if (!debug) continue;
            System.out.println(String.valueOf(file.getAbsolutePath()) + "..........OK");
        }
        if (debug) {
            System.out.println(new StringBuilder(logInfo).append(" END<<<"));
        }
    }

    private static void delTempFiles(String srcPath) {
        new File(String.valueOf(srcPath) + "//WEB-INF//lib//yuicompressor-2.4.2.jar").delete();
        new File(String.valueOf(srcPath) + "//temp.txt").delete();
        new File(String.valueOf(srcPath) + "//compressor.bat").delete();
        if (debug) {
            System.out.println("delete temp files...");
        }
    }

    private static boolean createBatFile(String srcPath, String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append("(dir %1 /aa /b /s | findstr /e /c:\"%TYPE%\") >tmp.txt").append(Constants.LS);
        sb.append("for /f %%i in (tmp.txt) do java -jar ");
        sb.append(srcPath).append("\\WEB-INF\\lib\\yuicompressor-2.4.2.jar");
        sb.append(" --type %TYPE% --charset ").append(encode);
        sb.append(" -o %%i.tmp %%i & copy %%i\".tmp\" %%i & del %%i\".tmp\"").append(Constants.LS);
        FileIO.writeToFile(String.valueOf(srcPath) + "//" + fileName, sb.toString().replaceAll("%TYPE%", "js"), false, encode);
        FileIO.writeToFile(String.valueOf(srcPath) + "//" + fileName, sb.toString().replaceAll("%TYPE%", "css"), true, encode);
        return true;
    }

    private static void execYuiCompression(String srcPath, String logInfo) throws IOException {
        if (BuilderWarPack.createBatFile(srcPath, "compressor.bat")) {
            Runtime runtime = Runtime.getRuntime();
            StringBuilder cmd = new StringBuilder("cmd /c");
            cmd.append("cd ").append(srcPath).append("&");
            cmd.append(BuilderWarPack.getDriver(srcPath)).append("&");
            cmd.append("compressor.bat");
            System.out.println(cmd.toString());
            process = runtime.exec(cmd.toString());
        }
        if (debug) {
            BuilderWarPack.execLogOut(logInfo);
        }
    }

    private static void execFileCompression(String srcPath, String logInfo) {
        List<File> fileList = FileIO.listFilesInDirSubdirs(new File(srcPath));
        if (debug) {
            System.out.println(new StringBuilder(logInfo).append(" START>>>"));
        }
        for (File file : fileList) {
            String fileName = file.getName();
            String suffixFileName = fileName.substring(fileName.lastIndexOf(".") + 1);
            boolean isJspFile = "jsp".equals(suffixFileName);
            if (!isJspFile) continue;
            List<String> cfileList = FileIO.readAsList(file, encode);
            StringBuilder sbContent = new StringBuilder();
            String content = "";
            boolean isJavaScript = false;
            boolean isNull = false;
            for (String line : cfileList) {
                line = line.trim();
                if (isJspFile) {
                    if (line.startsWith("<!--") && line.lastIndexOf("-->") > -1) {
                        line = "";
                    }
                    if (line.indexOf("<script") > -1) {
                        isJavaScript = true;
                    }
                    if (line.indexOf("</script") > -1) {
                        isJavaScript = false;
                    }
                    if (isJavaScript) {
                        if (line.startsWith("//")) {
                            line = "";
                        }
                        if (line.startsWith("/*")) {
                            isNull = true;
                            line = "";
                        }
                        if (line.startsWith("*/")) {
                            isNull = false;
                            line = "";
                        }
                        if (isNull) {
                            line = "";
                        }
                        if (line.indexOf(" //") > -1) {
                            if (line.indexOf(";") > -1 && line.indexOf(";") < line.indexOf("//")) {
                                line = line.substring(0, line.indexOf(";") + 1);
                            }
                            if (line.indexOf(",") > -1 && line.indexOf(",") < line.indexOf("//")) {
                                line = line.substring(0, line.indexOf(",") + 1);
                            }
                        }
                    }
                }
                sbContent.append(line);
            }
            content = sbContent.toString();
            FileIO.writeToFile(file.getAbsolutePath(), content, false, encode);
            if (!debug) continue;
            System.out.println(String.valueOf(file.getAbsolutePath()) + "..........OK");
        }
        if (debug) {
            System.out.println(new StringBuilder(logInfo).append(" END<<<"));
        }
    }

    private static void execCMD(String srcPath, String destPath, String logInfo) throws IOException {
        BuilderWarPack.delTempFiles(srcPath);
        Runtime runtime = Runtime.getRuntime();
        StringBuilder cmd = new StringBuilder("cmd /c");
        cmd.append("cd ").append(srcPath).append("&");
        cmd.append(BuilderWarPack.getDriver(srcPath)).append("&");
        cmd.append("jar cvf  ").append(destPath).append("  .");
        System.out.println(cmd.toString());
        process = runtime.exec(cmd.toString());
        if (debug) {
            BuilderWarPack.execLogOut(logInfo);
        }
    }

    private static void execLogOut(String logInfo) throws IOException {
        String log;
        System.out.println(new StringBuilder(logInfo).append(" START>>>"));
        BufferedReader buffIn = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((log = buffIn.readLine()) != null) {
            System.out.println(log);
        }
        buffIn.close();
        System.out.println(new StringBuilder(logInfo).append(" END<<<"));
    }

    private static String getDriver(String srcPath) {
        return srcPath.indexOf(":") > -1 ? srcPath.substring(0, srcPath.indexOf(":") + 1) : "c:";
    }
}

