/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.parse;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sysolar.mars.config.MarsContext;
import org.sysolar.mars.entity.DBColumn;
import org.sysolar.mars.entity.DBDataBase;
import org.sysolar.mars.entity.DBTable;
import org.sysolar.mars.entity.DBTableSpace;
import org.sysolar.util.RegexUtil;
import org.sysolar.util.file.FileIO;

public class ParseSql {
    public DBDataBase db = new DBDataBase();
    private String sqlContent = null;

    public ParseSql(MarsContext cts) {
        this.db.setSqlStruct(ParseSql.loadSqlFile(cts.getSourceSqlFile(), cts.getLanguage()));
        this.db.setDBTypeId(DBDataBase.getDBTypeId(this.getDBType()));
        cts.setDataBase(this.db.getDBTypeId());
        this.db.setCts(cts);
        this.initSqlContent();
        this.createDataBase(this.getAllTables());
    }

    public void initSqlContent() {
        String content = this.db.getSqlStruct();
        content = content.toUpperCase();
        content = RegexUtil.replaceAll(content, "\\/\\*.*\\*\\/");
        content = RegexUtil.replaceAll(content, "\\-\\-.*\\r\\n");
        content = content.replaceAll("\\r\\nGO", "\\;");
        this.sqlContent = content = content.replaceAll("\"", "");
    }

    public String getDBType() {
        return RegexUtil.getResultString(this.db.getSqlStruct(), "(DBMS name:)+[^\\n]+");
    }

    public static String loadSqlFile(String filePath, String enc) {
        return FileIO.readAsString(filePath, enc);
    }

    private static DBColumn getColumn(String columnName, List<DBColumn> columnList, String constraintType) {
        for (DBColumn col : columnList) {
            if (col.getName().indexOf(columnName) == -1) continue;
            col.setKeyType(constraintType);
            return col;
        }
        return null;
    }

    public Map<String, DBTable> getAllTables() {
        String regexCommentTable;
        LinkedHashMap<String, DBTable> tableMap = new LinkedHashMap<String, DBTable>();
        String regexCreateTable = "(CREATE TABLE)+[^\\;]+";
        List<String> contentList = RegexUtil.getResultList(this.getSqlContent(), regexCreateTable);
        switch (this.db.getCts().getDataBase()) {
            case 1: {
                regexCommentTable = "(ALTER TABLE)+[^\\;]+(COMMENT)+[^\\;]+";
                break;
            }
            case 2: {
                regexCommentTable = "(EXECUTE SP_ADDEXTENDEDPROPERTY 'MS_DESCRIPTION',)+[^\\;]+";
                break;
            }
            default: {
                regexCommentTable = "(COMMENT ON TABLE)+[^\\;]+";
            }
        }
        List<String> commentTableList = RegexUtil.getResultList(this.getSqlContent(), regexCommentTable);
        List<String> commentColumnList = null;
        if (this.db.getCts().getDataBase() == 0 || this.db.getCts().getDataBase() == 4 || this.db.getCts().getDataBase() == 5) {
            String regexCommentColumn = "(COMMENT ON COLUMN)+[^\\;]+";
            commentColumnList = RegexUtil.getResultList(this.getSqlContent(), regexCommentColumn);
        }
        String regexForeignKey = "(ALTER TABLE)+[^\\;]+(FOREIGN KEY)+[^\\;]+";
        List<String> foreignKeyList = RegexUtil.getResultList(this.getSqlContent(), regexForeignKey);
        for (String s : foreignKeyList) {
            System.out.println(s);
        }
        for (String str : contentList) {
            DBTable tb = new DBTable();
            String tableName = RegexUtil.replaceAll(RegexUtil.getResultString(str, "CREATE TABLE+[^\\(]+"), "CREATE TABLE");
            String columnGroup = RegexUtil.getResultString(str, "\\(+[^\\;]+");
            String[] colList = RegexUtil.getSplitResult(columnGroup, "[\n]");
            tb.setTableName(tableName);
            ArrayList<DBColumn> columnList = new ArrayList<DBColumn>();
            String[] stringArray = colList;
            int n = colList.length;
            int n2 = 0;
            while (n2 < n) {
                String col = stringArray[n2];
                String[] c = RegexUtil.getSplitResult(col.trim(), "[.]*[ ]+");
                if ("".equals(c[0]) || "(".equals(c[0]) || ")".equals(c[0]) || "KEY".equals(c[0]) || "PRIMARY".equals(c[0]) || "CONSTRAINT".equals(c[0]) || "INDEX".equals(c[0]) || "ENGINE".equals(c[0])) {
                    if (col.indexOf("PRIMARY") > -1) {
                        String primaryKey = RegexUtil.replaceAll(RegexUtil.getResultString(col, "\\(.*\\)"), "\\(", "\\)");
                        ParseSql.getColumn(primaryKey.trim(), columnList, "P");
                    }
                } else {
                    DBColumn dbCol = new DBColumn();
                    dbCol.setName(c[0]);
                    dbCol.setDataType(RegexUtil.getResultString(c[1], "[.\\w\\(\\,]*\\)"));
                    if (dbCol.getDataType().indexOf("(") > -1) {
                        dbCol.setLength(Integer.parseInt(RegexUtil.replaceAll(RegexUtil.getResultString(c[1], "\\(+[^\\,\\)]+"), "\\(")));
                        if (dbCol.getDataType().indexOf(",") > -1) {
                            dbCol.setPrecision(Integer.parseInt(RegexUtil.replaceAll(RegexUtil.getResultString(c[1], "\\,+[^\\)]+"), "\\,")));
                        }
                    }
                    if (col.indexOf("COMMENT") > -1 && col.indexOf("'") > -1 && this.db.getCts().getDataBase() == 1) {
                        String cmtCol = RegexUtil.replaceAll(RegexUtil.getResultString(col, "[\\']+[^\\']+"), "\\'").trim();
                        dbCol.setComment(cmtCol);
                    } else if (this.db.getCts().getDataBase() == 0 || this.db.getCts().getDataBase() == 4 || this.db.getCts().getDataBase() == 5) {
                        dbCol.setComment(this.addColumnComment(commentColumnList, tableName, c[0]));
                    } else if (this.db.getCts().getDataBase() == 2) {
                        dbCol.setComment(this.addColumnComment(commentTableList, tableName, c[0]));
                    }
                    if (col.indexOf("PRIMARY") > -1) {
                        dbCol.setKeyType("P");
                    }
                    System.out.println(col);
                    if (col.indexOf("INCREMENT") > -1) {
                        dbCol.setAutoIncrement(true);
                    }
                    dbCol.setFKeyTableName(this.addForeignKey(foreignKeyList, tableName, c[0]));
                    if (dbCol.getFKeyTableName().length() > 0) {
                        dbCol.setKeyType("F");
                    }
                    columnList.add(dbCol);
                }
                ++n2;
            }
            tb.setColList(columnList);
            tb.setTableComment(this.addTableComment(commentTableList, tableName));
            tableMap.put(tb.getTableName(), tb);
        }
        return tableMap;
    }

    private String addForeignKey(List<String> list, String tableName, String columnName) {
        for (String fKColumn : list) {
            if (!fKColumn.contains("ALTER TABLE " + tableName) || !fKColumn.contains(columnName) || this.db.getCts().getDataBase() != 0 && this.db.getCts().getDataBase() != 1) continue;
            return RegexUtil.replaceAll(RegexUtil.getResultString(fKColumn, "(REFERENCES)+[^\\(]+"), "REFERENCES").trim();
        }
        return "";
    }

    private String addColumnComment(List<String> list, String tableName, String columnName) {
        for (String commentColumn : list) {
            if (!commentColumn.contains(tableName) || !commentColumn.contains(columnName)) continue;
            if (this.db.getCts().getDataBase() == 2) {
                String comment = RegexUtil.replaceAll(commentColumn, "EXECUTE SP_ADDEXTENDEDPROPERTY \\'MS\\_DESCRIPTION\\'\\,");
                return RegexUtil.replaceAll(RegexUtil.getResultString(comment, "[\\']+[^\\,]+"), "\\'").trim();
            }
            return RegexUtil.replaceAll(RegexUtil.getResultString(commentColumn, "[\\']+[^\\']+"), "\\'").trim();
        }
        return "";
    }

    private String addTableComment(List<String> list, String tableName) {
        for (String commentTable : list) {
            if (!commentTable.contains(tableName) || commentTable.contains("COLUMN")) continue;
            if (this.db.getCts().getDataBase() == 2) {
                String comment = RegexUtil.replaceAll(commentTable, "EXECUTE SP_ADDEXTENDEDPROPERTY \\'MS\\_DESCRIPTION\\'\\,");
                return RegexUtil.replaceAll(RegexUtil.getResultString(comment, "[\\']+[^\\,]+"), "\\'").trim();
            }
            return RegexUtil.replaceAll(RegexUtil.getResultString(commentTable, "[\\']+[^\\']+"), "\\'").trim();
        }
        return "";
    }

    public void createDataBase(Map<String, DBTable> map) {
        ArrayList<DBTableSpace> tableSpaceList = new ArrayList<DBTableSpace>();
        tableSpaceList.add(new DBTableSpace().addTableList(map));
        this.db.setTableSpaceList(tableSpaceList);
    }

    public String getSqlContent() {
        return this.sqlContent;
    }
}

