/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.make;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.sysolar.mars.config.MarsContext;
import org.sysolar.mars.entity.DBColumn;
import org.sysolar.mars.entity.DBTable;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;

public class MakeJdo {
    private String packpageName = "packpageName";
    private String entityName = "entityName";
    private static Set<String> importSet = new TreeSet<String>();
    private StringBuilder sb = new StringBuilder(5000);
    private MarsContext cts;

    public MakeJdo() {
        this.cts = new MarsContext();
        importSet.clear();
        importSet.add("import java.util.Map;");
        importSet.add("import org.sysolar.sun.mvc.support.BaseBean;");
        importSet.add("import org.sysolar.sun.mvc.support.RequestWrapper;");
    }

    public MakeJdo(MarsContext cts) {
        this.cts = cts;
        this.packpageName = String.valueOf(cts.getPackageName()) + ".entity";
        importSet.clear();
        importSet.add("import java.util.Map;");
        if (cts.getChooseFillForResultSet() == 1) {
            importSet.add("import java.util.HashMap;");
        }
        importSet.add("import org.sysolar.sun.mvc.support.BaseBean;");
        importSet.add("import org.sysolar.sun.mvc.support.RequestWrapper;");
    }

    public static Set<String> getImportSet() {
        return importSet;
    }

    public static void setImportSet(Set<String> importSet) {
        MakeJdo.importSet = importSet;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getPackpageName() {
        return this.packpageName;
    }

    public void setPackpageName(String packpageName) {
        this.packpageName = packpageName;
    }

    private String getAllImportSet(Set<String> importSet, List<DBColumn> colList) {
        for (DBColumn col : colList) {
            System.out.println(String.valueOf(col.getName()) + " " + col.getJavaType());
            if (col.getJavaType() == null || !col.getJavaType().equals("Date")) continue;
            importSet.add("import java.util.Date;");
        }
        this.sb.delete(0, this.sb.length());
        this.sb.append(Constants.LS);
        for (String strImport : importSet) {
            this.sb.append(strImport).append(Constants.LS);
        }
        return this.sb.toString();
    }

    private String NVL(String str1, String str2) {
        return str1 == null ? str2 : str1;
    }

    private String addClassComment(DBTable DBTable2) {
        this.sb.delete(0, this.sb.length());
        this.sb.append(Constants.LS);
        this.sb.append("/**").append(Constants.LS);
        this.sb.append(" * ").append(this.NVL(DBTable2.getTableComment(), DBTable2.getTableName())).append(Constants.LS);
        this.sb.append(" */").append(Constants.LS);
        return this.sb.toString();
    }

    private void addConstructor(DBTable DBTable2, String className) {
        List<DBColumn> colList = DBTable2.getColList();
        if (this.cts.getChooseConstructor() > 0) {
            this.sb.append(Constants.LS);
            this.sb.append(Constants.BLANK_4).append("public ").append(className).append("() {}").append(Constants.LS);
        }
        if (this.cts.getChooseConstructor() > 1) {
            this.sb.append(Constants.LS);
            this.sb.append(Constants.BLANK_4).append("public ").append(className).append("(");
            String fieldName = "";
            for (DBColumn pk : colList) {
                if (pk.getKeyType().indexOf("P") <= -1) continue;
                fieldName = NameUtil.getJavaNameSmallFirst(pk.getName());
                this.sb.append(pk.getJavaType()).append(" ").append(fieldName).append(",");
            }
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(") {").append(Constants.LS);
            this.sb.append(Constants.BLANK_8).append("this.").append(fieldName).append(" = ").append(fieldName).append(";").append(Constants.LS);
            this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
        }
        if (this.cts.getChooseConstructor() > 2) {
            String fieldName;
            this.sb.append(Constants.LS);
            this.sb.append(Constants.BLANK_4).append("public ").append(className).append("(");
            for (DBColumn col : colList) {
                fieldName = NameUtil.getJavaNameSmallFirst(col.getName());
                this.sb.append(col.getJavaType()).append(" ").append(fieldName).append(",");
            }
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(") {").append(Constants.LS);
            for (DBColumn col : colList) {
                fieldName = NameUtil.getJavaNameSmallFirst(col.getName());
                this.sb.append(Constants.BLANK_8).append("this.").append(fieldName).append(" = ").append(fieldName).append(";").append(Constants.LS);
            }
            this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
        }
    }

    private void addfield(List<DBColumn> colList) {
        StringBuilder sbField = new StringBuilder(1000);
        for (DBColumn DBColumn2 : colList) {
            String fieldName = NameUtil.getJavaNameSmallFirst(DBColumn2.getName());
            sbField.append(Constants.BLANK_4).append("private ").append(DBColumn2.getJavaType()).append(" ").append(fieldName).append(";");
            sbField.append("//" + DBColumn2.getName() + " " + this.NVL(DBColumn2.getComment(), "")).append(Constants.LS);
        }
        this.sb.append((CharSequence)sbField);
    }

    private void addGetSetMethod(List<DBColumn> colSet, String className) {
        StringBuilder sbSetGetMethod = new StringBuilder(1000);
        for (DBColumn DBColumn2 : colSet) {
            String fieldName = NameUtil.getJavaNameSmallFirst(DBColumn2.getName());
            String fieldNameForMethod = NameUtil.getJavaNameBigFirst(DBColumn2.getName());
            if (this.cts.getChooseGetSet() == 2 || this.cts.getChooseGetSet() == 3) {
                sbSetGetMethod.append(Constants.LS);
                sbSetGetMethod.append(Constants.BLANK_4).append("public ").append(className).append(" set").append(fieldNameForMethod).append("(").append(DBColumn2.getJavaType()).append(" ").append(fieldName).append(") {").append(Constants.LS);
                sbSetGetMethod.append(Constants.BLANK_8).append("this.").append(fieldName).append(" = ").append(fieldName).append(";").append(Constants.LS);
                sbSetGetMethod.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
                sbSetGetMethod.append(Constants.BLANK_4).append("}").append(Constants.LS);
            }
            if (this.cts.getChooseGetSet() != 1 && this.cts.getChooseGetSet() != 3) continue;
            sbSetGetMethod.append(Constants.LS);
            sbSetGetMethod.append(Constants.BLANK_4).append("public ").append(DBColumn2.getJavaType()).append(" ").append(NameUtil.getJavaNameForGet(DBColumn2.getName())).append(" {").append(Constants.LS);
            sbSetGetMethod.append(Constants.BLANK_8).append("return ").append("this.").append(fieldName).append(";").append(Constants.LS);
            sbSetGetMethod.append(Constants.BLANK_4).append("}").append(Constants.LS);
        }
        this.sb.append((CharSequence)sbSetGetMethod);
        this.sb.append(Constants.LS);
    }

    private void addFillForMap(List<DBColumn> colSet, String className, String methodNmae) {
        this.sb.append(Constants.BLANK_4).append("public " + className + " ");
        this.sb.append(String.valueOf(methodNmae) + "(Map<String, Object> row) {").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("Object obj = null;").append(Constants.LS);
        for (DBColumn column : colSet) {
            String fieldName = NameUtil.getJavaNameSmallFirst(column.getName());
            this.sb.append(Constants.BLANK_8).append("if(null != (obj = row.get(\"").append(column.getName()).append("\"))) {").append(Constants.LS);
            this.sb.append(Constants.BLANK_12).append(fieldName).append(" = ");
            if (column.getJavaType().equals("Long")) {
                this.sb.append("((Number)obj).longValue();");
            } else if (column.getJavaType().equals("Integer")) {
                this.sb.append("((Number)obj).intValue();");
            } else if (column.getJavaType().equals("Double")) {
                this.sb.append("((Number)obj).doubleValue();");
            } else if (column.getJavaType().equals("String")) {
                this.sb.append("(String)obj;");
            } else {
                this.sb.append("(Date)obj;");
            }
            this.sb.append(Constants.LS);
            this.sb.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        this.sb.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private void addFillForJson(List<DBColumn> colSet, String className, String methodNmae) {
        this.sb.append(Constants.BLANK_4).append("@SuppressWarnings(\"unchecked\")").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("public " + className + " ");
        this.sb.append(String.valueOf(methodNmae) + "(Map<String, Object> json) {").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("Object value = null;").append(Constants.LS);
        for (DBColumn column : colSet) {
            String fieldName = NameUtil.getJavaNameSmallFirst(column.getName());
            this.sb.append(Constants.BLANK_8).append("if(null != (value = json.get(\"").append(fieldName).append("\"))) {").append(Constants.LS);
            this.sb.append(Constants.BLANK_12).append(fieldName).append(" = ");
            if (column.getJavaType().equals("Long")) {
                this.sb.append("Long.valueOf((String)value);");
            } else if (column.getJavaType().equals("Integer")) {
                this.sb.append("Integer.valueOf((String)value);");
            } else if (column.getJavaType().equals("Double")) {
                this.sb.append("Double.valueOf((String)value);");
            } else if (column.getJavaType().equals("String")) {
                this.sb.append("(String)value;");
            } else {
                this.sb.append("new Date(Long.valueOf((String)value));");
            }
            this.sb.append(Constants.LS);
            this.sb.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        this.sb.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private void addFillForResultSet(String className) {
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("public ").append(className);
        this.sb.append(" fill(ResultSet rs) throws SQLException {").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("ResultSetMetaData rsmd = rs.getMetaData();").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("int numberOfDBColumns = rsmd.getColumnCount();").append(Constants.LS);
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("Map<String, Object> map = new HashMap<String, Object>();").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("Object obj = null;").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("int sqlType = 0;").append(Constants.LS);
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("for(int i = 1; i <= numberOfDBColumns; i++) {").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("sqlType = rsmd.getColumnType(i);").append(Constants.LS);
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("if(sqlType == java.sql.Types.DATE) {").append(Constants.LS);
        this.sb.append(Constants.BLANK_16).append("obj = rs.getTimestamp(i);").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("}").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("else if(sqlType == java.sql.Types.CLOB) { ").append(Constants.LS);
        this.sb.append(Constants.BLANK_16).append("Clob clob = rs.getClob(i);").append(Constants.LS);
        this.sb.append(Constants.BLANK_16).append("obj = ").append("(clob != null ? clob.getSubString(1, (int)clob.length()) : null);").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("}").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("else {").append(Constants.LS);
        this.sb.append(Constants.BLANK_16).append("obj = rs.getObject(i);").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("}").append(Constants.LS);
        this.sb.append(Constants.BLANK_12).append("map.put(rsmd.getColumnName(i).toUpperCase(), obj);").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("}").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("return fill(map);").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private void addRequestWrapperMethod(List<DBColumn> colSet, String className) {
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("public " + className);
        this.sb.append(" fill(RequestWrapper wrapper) throws Exception {").append(Constants.LS);
        for (DBColumn column : colSet) {
            String fieldName = NameUtil.getJavaNameSmallFirst(column.getName());
            this.sb.append(Constants.BLANK_8).append(fieldName).append(" = wrapper.get");
            if (column.getJavaType().equals("Integer")) {
                this.sb.append("Int");
            } else {
                this.sb.append(column.getJavaType().toString());
            }
            this.sb.append("(\"");
            this.sb.append(String.valueOf(fieldName) + "\");").append(Constants.LS);
        }
        this.sb.append(Constants.BLANK_8).append("return this;").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private void addToStringMethod(List<DBColumn> colSet) {
        this.sb.append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("public String toString(){").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("StringBuilder sb = new StringBuilder(512)").append(".append(\"{\");").append(Constants.LS);
        for (DBColumn column : colSet) {
            String fieldName = NameUtil.getJavaNameSmallFirst(column.getName());
            this.sb.append(Constants.BLANK_8).append("if(null != ").append(fieldName).append("){").append(Constants.LS);
            this.sb.append(Constants.BLANK_12).append("sb.append(\"").append(fieldName);
            if (column.getJavaType().equals("Date")) {
                this.sb.append(":\").append(").append(fieldName).append(".getTime()").append(").append(\",\");");
            } else if (column.getJavaType().equals("String")) {
                this.sb.append(":'\").append(").append(fieldName).append(").append(\"',\");");
            } else {
                this.sb.append(":\").append(").append(fieldName).append(").append(\",\");");
            }
            this.sb.append(Constants.LS).append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        this.sb.append(Constants.BLANK_8).append("if(sb.length() > 1) {").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("    sb.deleteCharAt(sb.length() - 1);").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("}").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("sb.append(\"}\").trimToSize();").append(Constants.LS);
        this.sb.append(Constants.BLANK_8).append("return sb.toString();").append(Constants.LS);
        this.sb.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private String addClass(DBTable DBTable2) {
        this.sb.delete(0, this.sb.length());
        String className = NameUtil.getJavaNameBigFirst(DBTable2.getTableName());
        this.sb.append("public final class ").append(className).append(" extends BaseBean {").append(Constants.LS);
        this.addfield(DBTable2.getColList());
        this.addConstructor(DBTable2, className);
        this.addGetSetMethod(DBTable2.getColList(), className);
        if (this.cts.getChooseFillForMap() == 1) {
            this.addFillForMap(DBTable2.getColList(), className, "fill");
        }
        this.sb.append(Constants.LS);
        this.addFillForJson(DBTable2.getColList(), className, "fillJson");
        if (this.cts.getChooseFillForResultSet() == 1) {
            this.addFillForResultSet(className);
        }
        if (this.cts.getChooseRequestWrapper() == 1) {
            this.addRequestWrapperMethod(DBTable2.getColList(), className);
        }
        this.addToStringMethod(DBTable2.getColList());
        this.sb.append(Constants.LS);
        this.sb.append("}").append(Constants.LS);
        return this.sb.toString();
    }

    public String parse(DBTable DBTable2) {
        StringBuilder strEntity = new StringBuilder(5000);
        strEntity.append("package ").append(this.packpageName).append(";").append(Constants.LS);
        strEntity.append(this.getAllImportSet(importSet, DBTable2.getColList()));
        strEntity.append(this.addClassComment(DBTable2));
        strEntity.append(this.addClass(DBTable2));
        return strEntity.toString();
    }
}

