/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.make;

import java.util.List;
import org.sysolar.mars.entity.DBColumn;
import org.sysolar.mars.entity.DBTable;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;

public class MakeDml {
    public static String makeInsert(DBTable table, int dBTypeId) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Constants.LS).append(Constants.BLANK_4);
        sb.append("insert into ").append(table.getTableName()).append("(");
        List<DBColumn> colList = table.getColList();
        for (DBColumn col : colList) {
            sb.append(col.getName()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append(")").append(Constants.LS);
        sb.append(Constants.BLANK_4).append("values (");
        int i = 0;
        while (i < colList.size()) {
            sb.append(" ?,");
            ++i;
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.append(");").toString();
    }

    public static String makeUpdate(DBTable table) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Constants.LS).append(Constants.BLANK_4);
        sb.append("update ").append(table.getTableName()).append(" set ");
        for (DBColumn col : table.getColList()) {
            sb.append(col.getName()).append("= ? ,");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(") where ");
        for (DBColumn col : table.getColList()) {
            if (col.getKeyType().indexOf("P") <= -1) continue;
            sb.append(col.getName()).append("= ? ");
        }
        return sb.append(";").toString();
    }

    public static String makeDel(DBTable table) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Constants.LS).append(Constants.BLANK_4);
        sb.append("delete from ").append(table.getTableName()).append(" where ");
        for (DBColumn col : table.getColList()) {
            if (col.getKeyType().indexOf("P") <= -1) continue;
            sb.append(col.getName()).append(" = ? ");
            break;
        }
        return sb.append(";").toString();
    }

    public static String makeSelect(DBTable table) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Constants.LS).append(Constants.BLANK_4);
        sb.append("select * from ").append(table.getTableName()).append(" where ");
        for (DBColumn col : table.getColList()) {
            if (col.getKeyType().indexOf("P") <= -1) continue;
            sb.append(col.getName()).append(" = ?");
            break;
        }
        return sb.append(";").toString();
    }

    public static String makeExport(DBTable table) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(Constants.LS);
        sb.append(Constants.BLANK_4).append("select ");
        List<DBColumn> colList = table.getColList();
        for (DBColumn col : colList) {
            sb.append(col.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append(Constants.LS);
        sb.append(Constants.BLANK_4).append("from ").append(table.getTableName()).append(Constants.LS);
        sb.append(Constants.BLANK_4).append("order by ");
        for (DBColumn col : colList) {
            if (col.getKeyType().indexOf("P") <= -1) continue;
            sb.append(col.getName()).append(" asc");
            break;
        }
        sb.append(Constants.LS);
        sb.append(Constants.BLANK_4).append(" limit ?,?;");
        return sb.toString();
    }

    public static String createModule(DBTable table, int dBTypeId) {
        String className = NameUtil.getJavaNameBigFirst(table.getTableName());
        String[] setting = new String[]{String.valueOf(className) + "Model", "create", "update", "remove", "fetch", "export"};
        StringBuilder sbCreateModule = new StringBuilder(5000);
        sbCreateModule.append("# ##########################").append(Constants.LS);
        sbCreateModule.append("# ").append(setting[0]).append(Constants.LS);
        sbCreateModule.append("# ##########################").append(Constants.LS);
        sbCreateModule.append(setting[1]).append(" == ").append(MakeDml.makeInsert(table, dBTypeId)).append(Constants.LS);
        sbCreateModule.append(setting[3]).append(" == ").append(MakeDml.makeDel(table)).append(Constants.LS);
        sbCreateModule.append(setting[4]).append(" == ").append(MakeDml.makeSelect(table)).append(Constants.LS);
        sbCreateModule.append(setting[5]).append(" == ").append(MakeDml.makeExport(table)).append(Constants.LS);
        sbCreateModule.append(Constants.LS);
        return sbCreateModule.toString();
    }

    public static String createGeneric() {
        StringBuilder sbCreateModule = new StringBuilder(5000);
        sbCreateModule.append("# ##########################").append(Constants.LS);
        sbCreateModule.append("# ").append("generic").append(Constants.LS);
        sbCreateModule.append("# ##########################").append(Constants.LS);
        sbCreateModule.append("fetchLastInsertId").append(" == ").append("select @@IDENTITY;").append(Constants.LS);
        sbCreateModule.append(Constants.LS);
        return sbCreateModule.toString();
    }
}

