/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.mars.exec;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.sysolar.mars.config.MarsContext;
import org.sysolar.mars.entity.DBDataBase;
import org.sysolar.mars.entity.DBTable;
import org.sysolar.mars.make.MakeC;
import org.sysolar.mars.make.MakeD;
import org.sysolar.mars.make.MakeDao;
import org.sysolar.mars.make.MakeDml;
import org.sysolar.mars.make.MakeJdo;
import org.sysolar.mars.make.MakeR;
import org.sysolar.mars.parse.ParseSql;
import org.sysolar.mars.war.BuilderWarPack;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public class OutEntity {
    public DBDataBase db;

    public OutEntity(MarsContext cts) {
        this.db = new ParseSql((MarsContext)cts).db;
    }

    public void startEntities() throws SQLException {
        StringBuilder sbFilePath = new StringBuilder(100);
        List<DBTable> list = this.db.getTableSpaceList().get(0).getTableList();
        for (DBTable table : list) {
            sbFilePath.append(this.db.getCts().getPath()).append(this.db.getCts().getPackageName().replace('.', '/')).append("/entity/").append(NameUtil.getJavaNameBigFirst(table.getTableName())).append(".java");
            FileIO.writeToFile(sbFilePath.toString(), new MakeJdo(this.db.getCts()).parse(table), false, this.db.getCts().getLanguage());
            sbFilePath.delete(0, sbFilePath.length());
        }
    }

    public void startDML() throws SQLException {
        List<DBTable> list = this.db.getTableSpaceList().get(0).getTableList();
        for (DBTable table : list) {
            String filePath = String.valueOf(Constants.ROOT_PATH) + "\\sql\\" + table.getTableName() + ".sql";
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
            }
            FileIO.writeToFile(filePath, MakeDml.createModule(table, this.db.getDBTypeId()), true, this.db.getCts().getLanguage());
        }
        String filePath = String.valueOf(Constants.ROOT_PATH) + "\\sql\\generic.sql";
        FileIO.writeToFile(filePath, MakeDml.createGeneric(), false, this.db.getCts().getLanguage());
    }

    public void startDAO() throws SQLException {
        StringBuilder daoFilePath = new StringBuilder(100);
        StringBuilder implFilePath = new StringBuilder(100);
        List<DBTable> list = this.db.getTableSpaceList().get(0).getTableList();
        for (DBTable table : list) {
            daoFilePath.append(this.db.getCts().getPath()).append(this.db.getCts().getPackageName().replace('.', '/')).append("/dao/").append(NameUtil.getJavaNameBigFirst(table.getTableName())).append("Dao.java");
            FileIO.writeToFile(daoFilePath.toString(), MakeDao.createDAO(table, this.db.getCts().getPackageName(), this.db.getCts()), false, this.db.getCts().getLanguage());
            daoFilePath.delete(0, daoFilePath.length());
            implFilePath.append(this.db.getCts().getPath()).append(this.db.getCts().getPackageName().replace('.', '/')).append("/daoimpl/").append(NameUtil.getJavaNameBigFirst(table.getTableName())).append("DaoImpl.java");
            FileIO.writeToFile(implFilePath.toString(), MakeDao.createDAOImpl(table, this.db.getCts().getPackageName(), this.db.getCts()), false, this.db.getCts().getLanguage());
            implFilePath.delete(0, implFilePath.length());
        }
    }

    public static void main(String[] args) throws SQLException {
        if (args != null && args.length > 0) {
            if ("createwarpack".equalsIgnoreCase(args[0])) {
                try {
                    BuilderWarPack.execDo();
                }
                catch (IOException e) {
                    System.out.println("IOException");
                }
                return;
            }
            MarsContext.loadDefaults();
            OutEntity oe = new OutEntity(MarsContext.getGlobals());
            if ("createstruct".equalsIgnoreCase(args[0])) {
                oe.startEntities();
                oe.startDML();
                oe.startDAO();
                oe.startR();
                oe.startC();
                oe.startD();
            } else {
                oe.startR();
            }
        }
    }

    private void startR() {
        new MakeR(this.db.getCts());
    }

    private void startD() {
        List<DBTable> list = this.db.getTableSpaceList().get(0).getTableList();
        new MakeD(this.db.getCts(), list);
    }

    private void startC() {
        new MakeC(this.db.getCts());
    }
}

