/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.fileupload.core;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public abstract class FileUploadBase {
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int STATUS_BEGIN = 0;
    public static final int STATUS_READ_HEAD_DATA = 1;
    public static final int STATUS_READ_FIELD_DATA = 2;
    public static final int STATUS_READ_FILE_DATA = 3;
    protected HttpServletRequest request;
    protected byte[] dataBoundary;
    protected byte[] lastBoundary;

    public FileUploadBase(HttpServletRequest request) {
        this.request = request;
    }

    protected boolean isMultipartContent() {
        String contentType = this.request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith(MULTIPART);
    }

    protected void setBoundary() {
        String contentType = this.request.getContentType();
        String boundary = contentType.substring(contentType.indexOf("boundary") + 9);
        this.dataBoundary = ("--" + boundary).getBytes();
        this.lastBoundary = ("--" + boundary + "--").getBytes();
    }

    protected void setAttribute(String fieldName, String filedValue) {
        ArrayList<String> valueList = (ArrayList<String>)this.request.getAttribute(fieldName);
        if (valueList == null) {
            valueList = new ArrayList<String>(10);
            valueList.add(filedValue);
            this.request.setAttribute(fieldName, valueList);
        } else {
            valueList.add(filedValue);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

