/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.util.Constants;
import org.sysolar.util.file.FileIO;

public final class MakeSql {
    public static void doMake(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        File dir = config.getDir(2);
        LinkedHashMap<String, String> dmlMap = new LinkedHashMap<String, String>(20);
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            File dmlFile = new File(dir, String.valueOf(entity.getTableName()) + ".sql");
            if (dmlFile.exists()) {
                MakeSql.readOldDml(FileIO.readAsString(dmlFile, charset), dmlMap);
            }
            try {
                MakeSql.appendCreate(entity, dmlMap, config);
                MakeSql.appendRemove(entity, dmlMap);
                MakeSql.appendFetch(entity, dmlMap);
                MakeSql.appendExport(entity, dmlMap, config);
            }
            catch (Exception e) {
                System.out.println(entity);
                e.printStackTrace(System.out);
            }
            for (Map.Entry entry : dmlMap.entrySet()) {
                buffer.append((String)entry.getKey()).append(" ==").append(Constants.LS);
                buffer.append(Constants.BLANK_4).append((String)entry.getValue()).append(";").append(Constants.LS);
                buffer.append(Constants.LS);
            }
            FileIO.writeToFile(dmlFile, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
            dmlMap.clear();
        }
        if (config.getValue("derby") != null) {
            buffer.append("fetchLastInsertId == values IDENTITY_VAL_LOCAL();").append(Constants.LS);
        } else {
            buffer.append("fetchLastInsertId == select @@IDENTITY;").append(Constants.LS);
        }
        FileIO.writeToFile(new File(dir, "generic.sql"), buffer.toString(), false, charset);
    }

    public static void readOldDml(String oldDml, Map<String, String> dmlMap) {
        if ((oldDml = oldDml.trim()).equals("")) {
            return;
        }
        oldDml = oldDml.replaceAll("# .+\\s", "");
        String[] stringArray = oldDml.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            String[] arr = method.split("\\s*==\\s*");
            dmlMap.put(arr[0].trim(), arr[1].trim());
            ++n2;
        }
    }

    private static void appendCreate(Entity entity, Map<String, String> dmlMap, Config config) {
        StringBuilder buffer = new StringBuilder(256);
        int fieldNum = entity.getFieldList().size();
        buffer.append("insert into ").append(entity.getTableName()).append(" (").append(Constants.LS);
        int i = 1;
        for (Field field : entity.getFieldList()) {
            if (i % 5 == 1) {
                buffer.append(Constants.BLANK_8);
            }
            if (config.getValue("derby") != null && field.getKeyType() != null && 1 == field.getKeyType()) {
                ++i;
                continue;
            }
            buffer.append(field.getColumnName());
            if (i != fieldNum) {
                buffer.append(", ");
            }
            if (i % 5 == 0 && i != fieldNum) {
                buffer.append(Constants.LS);
            }
            ++i;
        }
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(") values (").append(Constants.LS);
        buffer.append(Constants.BLANK_8);
        i = 0;
        while (i < fieldNum) {
            if (config.getValue("derby") == null || i != 0) {
                buffer.append("?");
                if (i != fieldNum - 1) {
                    buffer.append(", ");
                }
            }
            ++i;
        }
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(")");
        dmlMap.put("create", buffer.toString());
    }

    private static void appendRemove(Entity entity, Map<String, String> dmlMap) {
        StringBuilder buffer = new StringBuilder(128);
        Field pk = entity.getPrimaryKey();
        buffer.append("delete from ").append(entity.getTableName()).append(" where ").append(pk.getColumnName()).append(" = ?");
        dmlMap.put("remove", buffer.toString());
    }

    private static void appendFetch(Entity entity, Map<String, String> dmlMap) {
        StringBuilder buffer = new StringBuilder(128);
        Field pk = entity.getPrimaryKey();
        buffer.append("select * from ").append(entity.getTableName()).append(" where ").append(pk.getColumnName()).append(" = ?");
        dmlMap.put("fetch", buffer.toString());
    }

    private static void appendExport(Entity entity, Map<String, String> dmlMap, Config config) {
        StringBuilder buffer = new StringBuilder(128);
        Field pk = entity.getPrimaryKey();
        if (config.getValue("derby") != null) {
            buffer.append("select T1.*").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("  from (select ROW_NUMBER() OVER() as ROWNUM").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("              ,R.").append(pk.getColumnName()).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("          from (select ").append(pk.getColumnName()).append(" from ").append(entity.getTableName()).append(" order by ").append(pk.getColumnName()).append(" desc) R) T0 ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" inner join ").append(entity.getTableName()).append(" T1 on T1.").append(pk.getColumnName()).append(" = T0.").append(pk.getColumnName()).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" where T0.ROWNUM >= ?").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("   and T0.ROWNUM <  ?");
        } else {
            buffer.append("select * from ").append(entity.getTableName()).append(" order by ").append(pk.getColumnName()).append(" desc limit ?,?");
        }
        dmlMap.put("export", buffer.toString());
    }
}

