/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.List;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public final class MakeLogic {
    public static void doMake(List<Entity> entityList, Config config) {
        MakeLogic.makeInteface(entityList, config);
        MakeLogic.makeImplement(entityList, config);
    }

    private static void makeInteface(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        String pack = config.getPackageName();
        File dir = config.getDir(6);
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            String className = entity.getClassName();
            String entityName = NameUtil.lowerCaseFirstChar(className);
            Field pk = entity.getPrimaryKey();
            buffer.append("package ").append(pack).append(".logic;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import java.util.List;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import ").append(pack).append(".entity.").append(className).append(";").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("public interface ").append(className).append("Logic {").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u63d2\u5165\u4e00\u6761\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(entityName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(entityName).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6279\u91cf\u63d2\u5165\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(entityName).append("List").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(List<").append(className).append("> ").append(entityName).append("List) throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u5220\u9664\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(pk.getFieldName()).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return \u88ab\u5220\u9664\u7684\u8bb0\u5f55\u6570\u91cf  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int remove(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u4fee\u6539\u5176\u5b83\u5b57\u6bb5\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(entityName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return  \u88ab\u4fee\u6539\u7684\u8bb0\u5f55\u6570\u91cf").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int update(").append(className).append(" ").append(entityName).append(") throws Exception;  ").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u83b7\u5f97\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(pk.getFieldName()).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public ").append(className).append(" fetch(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception; ").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u83b7\u5f97\u6570\u636e\u5217\u8868\u3002 ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param offset \u504f\u79fb\u91cf\uff0c\u7b2c\u4e00\u6761\u6570\u636e\u7684\u504f\u79fb\u91cf\u4e3a0").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param limit \u6570\u636e\u91cf").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/** ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u63d0\u4ea4\u7f13\u5b58\u91cc\u7684\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */ ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void flush() throws Exception;").append(Constants.LS);
            buffer.append("}").append(Constants.LS);
            File file = new File(dir, String.valueOf(className) + "Logic.java");
            FileIO.writeToFile(file, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
        }
    }

    private static void makeImplement(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        String pack = config.getPackageName();
        File dir = config.getDir(7);
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            String className = entity.getClassName();
            String entityName = NameUtil.lowerCaseFirstChar(className);
            Field pk = entity.getPrimaryKey();
            buffer.append("package ").append(pack).append(".logicimpl;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import static ").append(pack).append(".constant.Dao.").append(entityName).append("Dao;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import java.util.List;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import ").append(pack).append(".entity.").append(className).append(";").append(Constants.LS);
            buffer.append("import ").append(pack).append(".logic.").append(className).append("Logic;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("public final class ").append(className).append("LogicImpl implements ").append(className).append("Logic {").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(entityName).append(") throws Exception {").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append(entityName).append("Dao.create(").append(entityName).append(");").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(List<").append(className).append("> ").append(entityName).append("List) throws Exception { ").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append(entityName).append("Dao.create(").append(entityName).append("List);").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int remove(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception { ").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return ").append(entityName).append("Dao.remove(").append(pk.getFieldName()).append(");").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int update(").append(className).append(" ").append(entityName).append(") throws Exception { ").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return ").append(entityName).append("Dao.update(").append(entityName).append(");").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public ").append(className).append(" fetch(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception {").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return ").append(entityName).append("Dao.fetch(").append(pk.getFieldName()).append("); ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws Exception { ").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("return ").append(entityName).append("Dao.export(offset, limit); ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void flush() throws Exception {} ").append(Constants.LS);
            buffer.append("}").append(Constants.LS);
            File file = new File(dir, String.valueOf(className) + "LogicImpl.java");
            FileIO.writeToFile(file, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
        }
    }
}

