/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.List;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.codehelper.javaee.entity.FieldConstant;
import org.sysolar.util.Constants;
import org.sysolar.util.file.FileIO;

public final class MakeJsEntity {
    public static void doMake(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        File jsEntityDir = config.getDir(9);
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            String fieldName;
            String className = entity.getClassName();
            buffer.append(className).append(" = {").append(Constants.LS);
            if (entity.getConsList() != null) {
                for (FieldConstant cons : entity.getConsList()) {
                    buffer.append(Constants.BLANK_4).append(cons.getConsName()).append(" : ");
                    if ("String".equals(cons.getConsType())) {
                        buffer.append("'").append(cons.getConsValue()).append("'");
                    } else {
                        buffer.append(cons.getConsValue());
                    }
                    buffer.append(",").append(Constants.LS);
                }
                buffer.append(Constants.LS);
            }
            for (Field field : entity.getFieldList()) {
                if (field.getConsList() == null) continue;
                buffer.append(Constants.BLANK_4).append("// ").append(field.getComment()).append(Constants.LS);
                for (FieldConstant cons : field.getConsList()) {
                    buffer.append(Constants.BLANK_4).append(cons.getConsName()).append(" : ");
                    if ("String".equals(cons.getConsType())) {
                        buffer.append("'").append(cons.getConsValue()).append("'");
                    } else {
                        buffer.append(cons.getConsValue());
                    }
                    buffer.append(",").append(Constants.LS);
                }
                buffer.append(Constants.LS);
            }
            buffer.append(Constants.BLANK_4).append("toParam : function(f, d){").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("var p = {};").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("if(d) p.dispatch = d;").append(Constants.LS);
            for (Field field : entity.getFieldList()) {
                fieldName = field.getFieldName();
                buffer.append(Constants.BLANK_8).append("if(f.").append(fieldName).append(") p.").append(fieldName).append(" = f.").append(fieldName).append(".value.trim();").append(Constants.LS);
            }
            buffer.append(Constants.BLANK_8).append("return p;").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("},").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("setForm : function(f, j){").append(Constants.LS);
            for (Field field : entity.getFieldList()) {
                fieldName = field.getFieldName();
                buffer.append(Constants.BLANK_8).append("if(f.").append(fieldName).append(" && j.").append(fieldName).append(") f.").append(fieldName).append(".value = j.").append(fieldName).append(";").append(Constants.LS);
            }
            buffer.append(Constants.BLANK_4).append("},").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("resetForm : function(f){").append(Constants.LS);
            for (Field field : entity.getFieldList()) {
                fieldName = field.getFieldName();
                buffer.append(Constants.BLANK_8).append("if(f.").append(fieldName).append(") f.").append(fieldName).append(".value = '';").append(Constants.LS);
            }
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append("};").append(Constants.LS);
        }
        FileIO.writeToFile(new File(jsEntityDir, "entity.js"), buffer.toString(), false, charset);
    }
}

