/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.List;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public final class MakeDao {
    public static void doMake(List<Entity> entityList, Config config) {
        MakeDao.makeInteface(entityList, config);
        MakeDao.makeImplement(entityList, config);
    }

    private static void makeInteface(List<Entity> entityList, Config config) {
        String daoPack = String.valueOf(config.getPackageName()) + ".dao";
        String entityPack = String.valueOf(config.getPackageName()) + ".entity";
        File dir = config.getDir(4);
        String charset = config.getCharset();
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            String className = entity.getClassName();
            String vClassName = NameUtil.lowerCaseFirstChar(className);
            Field pk = entity.getPrimaryKey();
            String pkName = pk.getFieldName();
            String pkType = pk.getFieldType();
            buffer.append("package ").append(daoPack).append(";").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import java.util.List;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import ").append(entityPack).append(".").append(className).append(";").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("public interface ").append(className).append("Dao {").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u63d2\u5165\u4e00\u6761\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(vClassName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(vClassName).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u63d2\u5165\u4e00\u6761\u6570\u636e\u3002\u5f53 setId \u4e3a true \u65f6\uff0c\u8bbe\u7f6e ").append(vClassName).append(" \u7684\u5c5e\u6027 ").append(pkName).append(" \u4e3a\u65b0\u63d2\u5165\u7684 ID\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(vClassName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param setId \u662f\u5426\u8bbe\u7f6eID").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(vClassName).append(", boolean setId) throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6279\u91cf\u63d2\u5165\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(vClassName).append("List").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public void create(List<").append(className).append("> ").append(vClassName).append("List) throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u5220\u9664\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(pkName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return \u88ab\u5220\u9664\u7684\u8bb0\u5f55\u6570\u91cf").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int remove(").append(pkType).append(" ").append(pkName).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u4fee\u6539\u5176\u5b83\u5b57\u6bb5\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *  ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(vClassName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return  \u88ab\u4fee\u6539\u7684\u8bb0\u5f55\u6570\u91cf").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public int update(").append(className).append(" ").append(vClassName).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u6839\u636e ID \u83b7\u5f97\u6570\u636e\u3002").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param ").append(vClassName).append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public ").append(className).append(" fetch(").append(pkType).append(" ").append(pkName).append(") throws Exception;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("/**").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * \u83b7\u5f97\u6570\u636e\u5217\u8868\u3002 ").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" *").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param offset \u504f\u79fb\u91cf\uff0c\u7b2c\u4e00\u6761\u6570\u636e\u7684\u504f\u79fb\u91cf\u4e3a0").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @param limit \u6570\u636e\u91cf").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @return").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" * @throws Exception").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append(" */").append(Constants.LS);
            buffer.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws Exception;").append(Constants.LS);
            buffer.append("}").append(Constants.LS);
            File entityFile = new File(dir, String.valueOf(entity.getClassName()) + "Dao.java");
            FileIO.writeToFile(entityFile, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
        }
    }

    private static void makeImplement(List<Entity> entityList, Config config) {
        String pack = config.getPackageName();
        File dir = config.getDir(5);
        String charset = config.getCharset();
        StringBuilder buffer = new StringBuilder(1024);
        for (Entity entity : entityList) {
            String className = entity.getClassName();
            buffer.append("package ").append(pack).append(".daoimpl;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import java.util.ArrayList;").append(Constants.LS);
            buffer.append("import java.util.List;").append(Constants.LS);
            buffer.append("import java.util.Map;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import org.sysolar.sun.config.AppContext;").append(Constants.LS);
            buffer.append("import org.sysolar.sun.jdbc.core.JdbcOperations;").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("import ").append(config.getPackageName()).append(".constant.Sql;").append(Constants.LS);
            buffer.append("import ").append(config.getPackageName()).append(".dao.").append(className).append("Dao;").append(Constants.LS);
            buffer.append("import ").append(config.getPackageName()).append(".entity.").append(className).append(";").append(Constants.LS);
            buffer.append(Constants.LS);
            buffer.append("public final class ").append(className).append("DaoImpl implements ").append(className).append("Dao {").append(Constants.LS);
            buffer.append("    private final JdbcOperations dao = AppContext.getJdbcOperations(").append(className).append("Dao.class);").append(Constants.LS);
            MakeDao.appendCreate(entity, buffer);
            MakeDao.appendBatchCreate(entity, buffer);
            MakeDao.appendRemove(entity, buffer);
            MakeDao.appendUpdate(entity, buffer);
            MakeDao.appendFetch(entity, buffer);
            MakeDao.appendExport(entity, buffer);
            buffer.append("}").append(Constants.LS);
            File entityFile = new File(dir, String.valueOf(entity.getClassName()) + "DaoImpl.java");
            FileIO.writeToFile(entityFile, buffer.toString(), false, charset);
            buffer.delete(0, buffer.length());
        }
    }

    private static void appendCreate(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        String entityName = NameUtil.lowerCaseFirstChar(className);
        Field pk = entity.getPrimaryKey();
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(entityName).append(") throws Exception { ").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("this.create(").append(entityName).append(", false);").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public void create(").append(className).append(" ").append(entityName).append(", boolean setId) throws Exception {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("dao.update(Sql.").append(className).append("Sql.create, ").append(entityName).append(".setDefault().toArray());").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("if(setId) {").append(Constants.LS);
        buffer.append(Constants.BLANK_12).append(entityName).append(".set").append(NameUtil.upperCaseFirstChar(pk.getFieldName())).append("(dao.queryFor");
        if (pk.getFieldType().equals("Integer")) {
            buffer.append("Int");
        } else {
            buffer.append("Long");
        }
        buffer.append("(Sql.GenericSql.fetchLastInsertId));").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private static void appendBatchCreate(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        String entityName = NameUtil.lowerCaseFirstChar(className);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public void create(List<").append(className).append("> ").append(entityName).append("List) throws Exception { ").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("if(null == ").append(entityName).append("List || ").append(entityName).append("List.size() == 0) {").append(Constants.LS);
        buffer.append(Constants.BLANK_12).append("return;").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("List<Object[]> params = new ArrayList<Object[]>(").append(entityName).append("List.size());").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("for(").append(className).append(" ").append(entityName).append(" : ").append(entityName).append("List) {").append(Constants.LS);
        buffer.append(Constants.BLANK_12).append("params.add(").append(entityName).append(".setDefault().toArray());").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("dao.update(Sql.").append(className).append("Sql.create, params);").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private static void appendRemove(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        Field pk = entity.getPrimaryKey();
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public int remove(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return dao.update(Sql.").append(className).append("Sql.remove, ").append(pk.getFieldName()).append("); ").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private static void appendUpdate(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        String entityName = NameUtil.lowerCaseFirstChar(className);
        String tableName = entity.getTableName();
        Field pk = entity.getPrimaryKey();
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public int update(").append(className).append(" ").append(entityName).append(") throws Exception {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("List<Object> params = new ArrayList<Object>(10);").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("StringBuilder buffer = new StringBuilder(512);").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("buffer.append(\"update ").append(tableName).append(" set \");").append(Constants.LS);
        for (Field field : entity.getFieldList()) {
            if (field.getKeyType() != null && field.getKeyType() == 1) continue;
            String columnName = field.getColumnName();
            String getMethodName = ".get" + NameUtil.getJavaNameBigFirst(columnName);
            buffer.append(Constants.BLANK_8).append("if(null != ").append(entityName).append(getMethodName).append("()) {").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append("buffer.append(\"").append(columnName).append("=?,\");").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append("params.add(").append(entityName).append(getMethodName).append("());").append(Constants.LS);
            buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        }
        buffer.append(Constants.BLANK_8).append("buffer.deleteCharAt(buffer.length() - 1);").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("buffer.append(\" where ").append(pk.getColumnName()).append(" = ?\");").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("params.add(").append(entityName).append(".get").append(NameUtil.getJavaNameBigFirst(pk.getColumnName())).append("());").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return dao.update(buffer.toString(), params.toArray());").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private static void appendFetch(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        Field pk = entity.getPrimaryKey();
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public ").append(className).append(" fetch(").append(pk.getFieldType()).append(" ").append(pk.getFieldName()).append(") throws Exception {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("for(Map<String, Object> row : dao.queryForList(Sql.").append(className).append("Sql.fetch, ").append(pk.getFieldName()).append(")) {").append(Constants.LS);
        buffer.append(Constants.BLANK_12).append("return new ").append(className).append("().fill(row); ").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return null;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }

    private static void appendExport(Entity entity, StringBuilder buffer) {
        String className = entity.getClassName();
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("@Override").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("public List<").append(className).append("> export(int offset, int limit) throws Exception {").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("List<").append(className).append("> list = new ArrayList<").append(className).append(">(limit);").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("for(Map<String, Object> row : dao.queryForList(Sql.").append(className).append("Sql.export, offset, limit)) {").append(Constants.LS);
        buffer.append(Constants.BLANK_12).append("list.add(new ").append(className).append("().fill(row)); ").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("return list;").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
    }
}

