/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.codehelper.javaee.make.MakeSql;
import org.sysolar.util.Constants;
import org.sysolar.util.NameUtil;
import org.sysolar.util.file.FileIO;

public final class MakeConstant {
    public static void doMake(List<Entity> entityList, Config config) {
        MakeConstant.makeSqlConstant(entityList, config);
        MakeConstant.makeDaoConstant(entityList, config);
        MakeConstant.makeLogicConstant(entityList, config);
    }

    public static void makeSqlConstant(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        File consDir = config.getDir(3);
        File sqlDir = config.getDir(2);
        LinkedHashMap<String, String> dmlMap = new LinkedHashMap<String, String>(20);
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("package " + config.getPackageName() + ".constant;").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append("import static org.sysolar.util.Constants.LS;").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append("public final class Sql {").append(Constants.LS);
        List<File> sqlFileList = FileIO.listFilesInDirSubdirs(sqlDir);
        for (File sqlFile : sqlFileList) {
            MakeSql.readOldDml(FileIO.readAsString(sqlFile, charset), dmlMap);
            String fileName = sqlFile.getName();
            fileName = fileName.substring(0, fileName.length() - 4);
            String className = NameUtil.getJavaNameBigFirst(fileName);
            buffer.append(Constants.BLANK_4).append("public static final class ").append(className).append("Sql").append(" {").append(Constants.LS);
            for (Map.Entry entry : dmlMap.entrySet()) {
                String key = (String)entry.getKey();
                String sql = (String)entry.getValue();
                buffer.append(Constants.BLANK_8).append("public static final String ").append(key);
                if (sql.indexOf("-- @") < 0) {
                    sql = sql.replaceAll("\\s+", " ").replaceAll("\\s*,\\s*", ",").replaceAll("\\s*=\\s*", "=");
                    buffer.append(" = \"").append(sql).append("\";").append(Constants.LS);
                    continue;
                }
                buffer.append(";").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("static {").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("StringBuilder buffer = new StringBuilder(512);").append(Constants.LS);
                String[] stringArray = sql.split("[\\n\\r]{1,2}");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    buffer.append(Constants.BLANK_12).append("buffer.append(\"").append(line.trim()).append("\").append(LS);").append(Constants.LS);
                    ++n2;
                }
                buffer.append(Constants.BLANK_12).append(key).append(" = buffer.toString();").append(Constants.LS);
                buffer.append(Constants.BLANK_12).append("buffer.delete(0, buffer.length());").append(Constants.LS);
                buffer.append(Constants.BLANK_8).append("}").append(Constants.LS);
            }
            buffer.append(Constants.BLANK_4).append("}").append(Constants.LS);
            buffer.append(Constants.LS);
            dmlMap.clear();
        }
        buffer.append("}");
        FileIO.writeToFile(new File(consDir, "Sql.java"), buffer.toString(), false, charset);
    }

    public static void makeDaoConstant(List<Entity> entityList, Config config) {
        String className;
        String charset = config.getCharset();
        String pack = config.getPackageName();
        File consDir = config.getDir(3);
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("package ").append(pack).append(".constant;").append(Constants.LS);
        buffer.append(Constants.LS);
        for (Entity entity : entityList) {
            className = entity.getClassName();
            buffer.append("import ").append(pack).append(".dao.").append(className).append("Dao;").append(Constants.LS);
            buffer.append("import ").append(pack).append(".daoimpl.").append(className).append("DaoImpl;").append(Constants.LS);
        }
        buffer.append(Constants.LS);
        buffer.append("public final class Dao {").append(Constants.LS);
        for (Entity entity : entityList) {
            className = entity.getClassName();
            String entityName = NameUtil.lowerCaseFirstChar(className);
            buffer.append(Constants.BLANK_4).append("public static final ").append(className).append("Dao ").append(entityName).append("Dao = new ").append(className).append("DaoImpl();").append(Constants.LS);
        }
        buffer.append("}");
        FileIO.writeToFile(new File(consDir, "Dao.java"), buffer.toString(), false, charset);
    }

    public static void makeLogicConstant(List<Entity> entityList, Config config) {
        String className;
        String charset = config.getCharset();
        String pack = config.getPackageName();
        File consDir = config.getDir(3);
        File logicDir = config.getDir(6, true);
        List<File> logicFileList = FileIO.listFilesInDirSubdirs(logicDir);
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("package ").append(pack).append(".constant;").append(Constants.LS);
        buffer.append(Constants.LS);
        for (File file : logicFileList) {
            className = file.getName().replace(".java", "");
            buffer.append("import ").append(pack).append(".logic.").append(className).append(";").append(Constants.LS);
            buffer.append("import ").append(pack).append(".logicimpl.").append(className).append("Impl;").append(Constants.LS);
        }
        buffer.append(Constants.LS);
        buffer.append("public final class Logic {").append(Constants.LS);
        for (File file : logicFileList) {
            className = file.getName().replace(".java", "");
            String entityName = NameUtil.lowerCaseFirstChar(className);
            buffer.append(Constants.BLANK_4).append("public static final ").append(className).append(" ").append(entityName).append(" = new ").append(className).append("Impl();").append(Constants.LS);
        }
        buffer.append("}");
        FileIO.writeToFile(new File(consDir, "Logic.java"), buffer.toString(), false, charset);
    }
}

