/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.make;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sysolar.codehelper.javaee.entity.Config;
import org.sysolar.codehelper.javaee.entity.Entity;
import org.sysolar.util.Constants;
import org.sysolar.util.file.FileIO;

public final class MakeConfig {
    public static void doMake(List<Entity> entityList, Config config) {
        MakeConfig.makeSysolarConfig(entityList, config);
    }

    public static void makeSysolarConfig(List<Entity> entityList, Config config) {
        String charset = config.getCharset();
        File srcDir = config.getDir(0);
        File actionDir = config.getDir(8, true);
        String pack = String.valueOf(config.getPackageName()) + ".action.";
        TreeMap<String, String> actionMap = new TreeMap<String, String>();
        List<File> actionFileList = FileIO.listFilesInDirSubdirs(actionDir);
        for (File actionFile : actionFileList) {
            String actionName = actionFile.getName().replace(".java", "");
            actionMap.put(String.valueOf(pack) + actionName, "/" + actionName + ".do");
        }
        StringBuilder buffer = new StringBuilder(1024);
        File configFile = new File(srcDir, "sysolar.config.xml");
        if (configFile.exists()) {
            return;
        }
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(Constants.LS);
        buffer.append("<sysolar>").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<!-- Action\u914d\u7f6e -->").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append(MakeConfig.buildActionString(actionMap)).append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<!-- Form\u8868\u5355POST\u65b9\u5f0f\u4f20\u9012\u53c2\u6570\u7684\u7f16\u7801\u5904\u7406 -->").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<character-encoding>").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("<post>UTF-8</post>").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("</character-encoding>").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<!-- \u6570\u636e\u6e90\u914d\u7f6e -->").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<database>").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("<database-type>mysql</database-type>").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("<data-source-name>db_5i56_com</data-source-name>").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("</database>").append(Constants.LS);
        buffer.append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<!-- key-value \u914d\u7f6e -->").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("<values>").append(Constants.LS);
        buffer.append(Constants.BLANK_8).append("<item key=\"KEY\">VALUE</item>").append(Constants.LS);
        buffer.append(Constants.BLANK_4).append("</values>").append(Constants.LS);
        buffer.append("</sysolar>");
        FileIO.writeToFile(configFile, buffer.toString(), false, charset);
    }

    private static String buildActionString(Map<String, String> actionMap) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<action-mappings>").append(Constants.LS);
        for (Map.Entry<String, String> entry : actionMap.entrySet()) {
            buffer.append(Constants.BLANK_8).append("<action-mapping").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append("path=\"").append(entry.getValue()).append("\"").append(Constants.LS);
            buffer.append(Constants.BLANK_12).append("class=\"").append(entry.getKey()).append("\" />").append(Constants.LS);
        }
        buffer.append(Constants.BLANK_4).append("</action-mappings>");
        return buffer.toString();
    }
}

