/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.codehelper.javaee.entity;

import java.util.ArrayList;
import java.util.List;
import org.sysolar.codehelper.javaee.entity.Field;
import org.sysolar.codehelper.javaee.entity.FieldConstant;
import org.sysolar.util.Constants;

public final class Entity {
    private String tableName;
    private String tableComment;
    private String className;
    private List<Field> fieldList;
    private List<Field> propertyList;
    private List<Entity> parentList;
    private List<Entity> childList;
    private List<FieldConstant> consList;
    private boolean childStatus = false;

    public Entity addField(Field field) {
        if (this.fieldList == null) {
            this.fieldList = new ArrayList<Field>(20);
        }
        this.fieldList.add(field);
        return this;
    }

    public Entity addProperty(Field property) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<Field>(20);
        }
        this.propertyList.add(property);
        return this;
    }

    public Entity addParent(Entity parent) {
        if (this.parentList == null) {
            this.parentList = new ArrayList<Entity>(20);
        }
        this.parentList.add(parent);
        return this;
    }

    public Entity removeParent(Entity parent) {
        this.parentList.remove(parent);
        return this;
    }

    public Entity addChild(Entity child) {
        if (this.childList == null) {
            this.childList = new ArrayList<Entity>(20);
        }
        this.childList.add(child);
        return this;
    }

    public Entity removeChild(Entity child) {
        this.childList.remove(child);
        return this;
    }

    public Entity addConstant(FieldConstant constant) {
        if (this.consList == null) {
            this.consList = new ArrayList<FieldConstant>(10);
        }
        this.consList.add(constant);
        return this;
    }

    public Field getPrimaryKey() {
        for (Field field : this.fieldList) {
            if (field.getKeyType() == null || field.getKeyType() != 1) continue;
            return field;
        }
        return null;
    }

    public Field getField(String columnName) {
        for (Field field : this.fieldList) {
            if (!field.getColumnName().equals(columnName)) continue;
            return field;
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200).append("{");
        buffer.append("tableName:").append(this.tableName);
        buffer.append(", fieldList:").append(this.fieldList);
        if (this.parentList != null) {
            buffer.append(Constants.LS).append(Constants.BLANK_8).append(",parentList:[");
            for (Entity parent : this.parentList) {
                buffer.append(parent.getTableName()).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length());
            buffer.append("]");
        }
        if (this.childList != null) {
            buffer.append(Constants.LS).append(Constants.BLANK_8).append(",childList:[");
            for (Entity child : this.childList) {
                buffer.append(child.getTableName()).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length());
            buffer.append("]");
        }
        return buffer.append("}").toString();
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public List<Field> getPropertyList() {
        return this.propertyList;
    }

    public List<Field> getFieldAndPropertyList() {
        ArrayList<Field> list = new ArrayList<Field>(this.fieldList);
        if (this.propertyList != null) {
            list.addAll(this.propertyList);
        }
        return list;
    }

    public List<Entity> getParentList() {
        return this.parentList;
    }

    public List<Entity> getChildList() {
        return this.childList;
    }

    public boolean getChildStatus() {
        return this.childStatus;
    }

    public Entity setChildStatus(boolean childStatus) {
        this.childStatus = childStatus;
        return this;
    }

    public Entity setChildList(List<Entity> childList) {
        this.childList = childList;
        return this;
    }

    public List<FieldConstant> getConsList() {
        return this.consList;
    }

    public void setConsList(List<FieldConstant> consList) {
        this.consList = consList;
    }
}

