; Copyleft (c) n/a-n/a Azure Zanculmarktum

!define FILENAME    "Sandboxie_Portable_${VER}_${APPLANG}"
!define APPNAME     "Sandboxie"
!define APP         "Sandboxie"
!define APPVER      "4.8.0.0"
!define VER         "4.08"
!define APPLANG     "Multilingual"
!define FOLDER      "SandboxiePortable"
!define LAUNCHER    "SandboxiePortable"
!define APPDIR      "Sandboxie"
!define APPDIR64    "Sandboxie64"
!define APPINFO
	!define PUBLISHER    "Sandboxie Holdings, LLC"
	!define HOMEPAGE     "http://www.google.com/search?q=${FILENAME}.paf"
	!define CATEGORY     "Security"
	!define DESCRIPTION  "Runs your programs in an isolated space"
	!define LANGUAGE     "Multilingual"
!define HELP
!define SOURCE
!define INIT

; === Best Compression ===
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

; === Include ===
!include Include\Installer.nsh

Section "${APPNAME} Portable" Main
	SetDetailsPrint textonly
	DetailPrint "Extracting ${APPNAME} Portable..."
	SetDetailsPrint listonly
	SetDetailsView hide

	SectionIn RO

	!ifndef COMMONFILESPLUGIN
		SetOutPath "$INSTDIR"
			File "..\..\${LAUNCHER}.exe"
		!ifndef LANGDIR
			SetOutPath "$INSTDIR\App\${APPDIR}"
				File /r /x thumbs.db "..\..\App\${APPDIR}\*.*"
			SetOutPath "$INSTDIR\App\${APPDIR64}"
				File /r /x thumbs.db "..\..\App\${APPDIR64}\*.*"
		!else
			SetOutPath "$INSTDIR\App\${APPDIR}"
				File /r /x thumbs.db /x ${LANGDIR} "..\..\App\${APPDIR}\*.*"
		!endif
	!else
		CreateDirectory "$INSTDIR\CommonFiles\${APPDIR}\files"
			File /r /x thumbs.db "..\..\files\*.*"
	!endif

	Call AppInfo

	Call Help

	Call Source
SectionEnd

!ifdef INIT
	Function Init
		; === Destroy size lol ===
		SectionSetSize ${Main} 0
	FunctionEnd
!endif
