; Azure Zanculmarktum
;
; Last modified: 2013-08-21
;
; ==================================================
; Usage:
; ==================================================
; ${CopyFiles} "[source_directory]" "[destination_directory]" "[file_type]" "[option]"
; ${CopyFilesWithout} "[file1]" ; you can insert
; ${CopyFilesWithout} "[file2]" ; files
; ${CopyFilesWithout} "[file3]" ; without limited
; ${CopyFilesEnd}
;
; ==================================================
; Example:
; ==================================================
; Copy all txt files:
; ${CopyFiles} "$EXEDIR\Test1" "$EXEDIR\Test2" "txt" "DEFAULT"
; ${CopyFilesEnd}
;
; Copy all files:
; ${CopyFiles} "$EXEDIR\Test1" "$EXEDIR\Test2" "ALL" "DEFAULT"
; ${CopyFilesEnd}
;
; Copy all files without some files:
; ${CopyFiles} "$EXEDIR\Test1" "$EXEDIR\Test2" "ALL" "DEFAULT"
; ${CopyFilesWithout} "test1.exe"
; ${CopyFilesWithout} "test2.exe"
; ${CopyFilesWithout} "test3.exe"
; ${CopyFilesEnd}
;
; Force to copy all files:
; ${CopyFiles} "$EXEDIR\Test1" "$EXEDIR\Test2" "ALL" "FORCE"
; ${CopyFilesEnd}
;
; ==================================================
; Notes
; ==================================================
; Usage of MoveFiles is same with CopyFiles

!ifndef _CopyMoveFiles_Included
!define _CopyMoveFiles_Included

Var _CopyFilesVar1
Var _CopyFilesVar2
Var _CopyFilesVar3
Var _CopyFilesVar4
Var _CopyFilesVar5
Var _CopyFilesVar6

Var _MoveFilesVar1
Var _MoveFilesVar2
Var _MoveFilesVar3
Var _MoveFilesVar4
Var _MoveFilesVar5
Var _MoveFilesVar6

!macro _CopyFiles SourceDir DestDir FileType Option
	StrCpy $_CopyFilesVar3 "${SourceDir}"
	StrCpy $_CopyFilesVar4 "${DestDir}"
	StrCpy $_CopyFilesVar5 "${Option}"
	StrCpy $_CopyFilesVar6 "${FileType}"

	!define _Local "${__LINE__}"
	!define _CopyFilesSet

	StrCmp $_CopyFilesVar6 "ALL" _CopyFiles${_Local}
		FindFirst $_CopyFilesVar1 $_CopyFilesVar2 "$_CopyFilesVar3\*.$_CopyFilesVar6"
		Goto _CopyFilesLoop${_Local}
	_CopyFiles${_Local}:
		FindFirst $_CopyFilesVar1 $_CopyFilesVar2 "$_CopyFilesVar3\*.*"
	_CopyFilesLoop${_Local}:
		StrCmp $_CopyFilesVar2 "" _CopyFilesEnd${_Local}
		StrCmp $_CopyFilesVar2 "." _CopyFilesNext${_Local}
		StrCmp $_CopyFilesVar2 ".." _CopyFilesNext${_Local}
!macroend

!define CopyFiles "!insertmacro _CopyFiles"

!macro _CopyFilesWithout File
	!ifndef _CopyFilesSet
		!error "Incorrect use of CopyFiles commands!"
	!endif

	StrCmp $_CopyFilesVar2 "${File}" _CopyFilesNext${_Local}
!macroend

!define CopyFilesWithout "!insertmacro _CopyFilesWithout"

!macro _CopyFilesEnd
	!ifndef _CopyFilesSet
		!error "Incorrect use of CopyFiles commands!"
	!else
		!undef _CopyFilesSet

		!ifndef _MoveFilesSet
			StrCpy $_MoveFilesVar1 ""
			StrCpy $_MoveFilesVar2 ""
			StrCpy $_MoveFilesVar3 ""
			StrCpy $_MoveFilesVar4 ""
			StrCpy $_MoveFilesVar5 ""
			StrCpy $_MoveFilesVar6 ""
		!endif
	!endif

	StrCmp $_CopyFilesVar5 "FORCE" _CopyFilesNow${_Local}
		IfFileExists "$_CopyFilesVar4\$_CopyFilesVar2" _CopyFilesNext${_Local}
	_CopyFilesNow${_Local}:
		CopyFiles /SILENT "$_CopyFilesVar3\$_CopyFilesVar2" "$_CopyFilesVar4"
	_CopyFilesNext${_Local}:
		FindNext $_CopyFilesVar1 $_CopyFilesVar2
		Goto _CopyFilesLoop${_Local}
	_CopyFilesEnd${_Local}:
		FindClose $_CopyFilesVar1

	!undef _Local
!macroend

!define CopyFilesEnd "!insertmacro _CopyFilesEnd"



!macro _MoveFiles SourceDir DestDir FileType Option
	StrCpy $_MoveFilesVar3 "${SourceDir}"
	StrCpy $_MoveFilesVar4 "${DestDir}"
	StrCpy $_MoveFilesVar5 "${Option}"
	StrCpy $_MoveFilesVar6 "${FileType}"

	!define _Local "${__LINE__}"
	!define _MoveFilesSet

	StrCmp $_MoveFilesVar6 "ALL" _MoveFiles${_Local}
		FindFirst $_MoveFilesVar1 $_MoveFilesVar2 "$_MoveFilesVar3\*.$_MoveFilesVar6"
		Goto _MoveFilesLoop${_Local}
	_MoveFiles${_Local}:
		FindFirst $_MoveFilesVar1 $_MoveFilesVar2 "$_MoveFilesVar3\*.*"
	_MoveFilesLoop${_Local}:
		StrCmp $_MoveFilesVar2 "" _MoveFilesEnd${_Local}
		StrCmp $_MoveFilesVar2 "." _MoveFilesNext${_Local}
		StrCmp $_MoveFilesVar2 ".." _MoveFilesNext${_Local}
!macroend

!define MoveFiles "!insertmacro _MoveFiles"

!macro _MoveFilesWithout File
	!ifndef _MoveFilesSet
		!error "Incorrect use of MoveFiles commands!"
	!endif

	StrCmp $_MoveFilesVar2 "${File}" _MoveFilesNext${_Local}
!macroend

!define MoveFilesWithout "!insertmacro _MoveFilesWithout"

!macro _MoveFilesEnd
	!ifndef _MoveFilesSet
		!error "Incorrect use of MoveFiles commands!"
	!else
		!undef _MoveFilesSet

		!ifndef _CopyFilesSet
			StrCpy $_CopyFilesVar1 ""
			StrCpy $_CopyFilesVar2 ""
			StrCpy $_CopyFilesVar3 ""
			StrCpy $_CopyFilesVar4 ""
			StrCpy $_CopyFilesVar5 ""
			StrCpy $_CopyFilesVar6 ""
		!endif
	!endif

	StrCmp $_MoveFilesVar5 "FORCE" "" _MoveFilesNow${_Local}
		IfFileExists "$_MoveFilesVar4\$_MoveFilesVar2\*.*" "" +3
			RMDir /r "$_MoveFilesVar4\$_MoveFilesVar2"
			Goto +2
		Delete "$_MoveFilesVar4\$_MoveFilesVar2"
	_MoveFilesNow${_Local}:
		Rename "$_MoveFilesVar3\$_MoveFilesVar2" "$_MoveFilesVar4\$_MoveFilesVar2"
	_MoveFilesNext${_Local}:
		FindNext $_MoveFilesVar1 $_MoveFilesVar2
		Goto _MoveFilesLoop${_Local}
	_MoveFilesEnd${_Local}:
		FindClose $_MoveFilesVar1

	!undef _Local
!macroend

!define MoveFilesEnd "!insertmacro _MoveFilesEnd"
!endif