; Last updated: 2013-12-08

; Useful for portable app which launcher (*Portable.exe) need to be executed as administrator privileges,
; but target (App\Program\program.exe) need to be executed (by launcher) as user privileges.
; Requires StdUtils plugin and FindProcDLL (modified by hnedka) plugin [search on Google :P].
;
; Usage: simply replace ; === Launch === (in *Portable.nsi) with this:

	; === Launch ===
	SetOutPath "$PROGRAMDIR" ; lock rename!
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "ExecAsAdmin"
	StrCmp $0 "" "" +2
		WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "ExecAsAdmin" "false"
	StrCmp $0 "true" ExecWaitAsAdmin ExecWaitAsUser
	ExecWaitAsUser:
		StrCpy $PROGRAMSWITCH "$PROGRAMSWITCH" "" 1 ; remove first space
		StrCmp `$PARAMETERS` `` ExecWaitAsUserWithoutParameters ExecWaitAsUserWithParameters
		ExecWaitAsUserWithoutParameters:
			StdUtils::ExecShellAsUser /NOUNLOAD `$PROGRAMSWITCH` "" "$PROGRAMDIR\$PROGRAMEXE"
			Goto CheckStillRunning
		ExecWaitAsUserWithParameters:
			StdUtils::ExecShellAsUser /NOUNLOAD `$PROGRAMSWITCH $PARAMETERS` "" "$PROGRAMDIR\$PROGRAMEXE"
			Goto CheckStillRunning
	ExecWaitAsAdmin:
		StrCmp `$PARAMETERS` `` ExecWaitAsAdminWithoutParameters ExecWaitAsAdminWithParameters
		ExecWaitAsAdminWithoutParameters:
			ExecWait `"$PROGRAMDIR\$PROGRAMEXE"$PROGRAMSWITCH`
			Goto CheckStillRunning
		ExecWaitAsAdminWithParameters:
			ExecWait `"$PROGRAMDIR\$PROGRAMEXE"$PROGRAMSWITCH $PARAMETERS`
	CheckStillRunning:
		; Wait until app closed:
		FindProcDLL::WaitProcEnd "$PROGRAMEXE" -1 ; FindProcDLL modified by hnedka
		FindProcDLL::FindProc "$PROGRAMEXE"
		StrCmp $R0 "1" "" +3
			Sleep 2000
			Goto -3
