//
//  SMUGRealDoubleMatrix.h
//  SMUGMath
//
//  Created by Christopher Liscio on 6/20/13.
//
//

#import <Foundation/Foundation.h>
#import <SMUGMath/SMUGRealDoubleVector.h>

@interface SMUGRealDoubleMatrix : NSObject {
    SMUGRealDoubleVector *mVector;
    uint64_t mRows;
    uint64_t mColumns;
}

#pragma mark Constructors

- (id)initWithRows:(uint64_t)rows columns:(uint64_t)cols;
- (id)initWithRealDoubleVector:(SMUGRealDoubleVector*)realVector rows:(uint64_t)rows columns:(uint64_t)cols;
- (id)initWithRealDoubleVectorNoCopy:(SMUGRealDoubleVector*)realVector rows:(uint64_t)rows columns:(uint64_t)cols;

+ (instancetype)onesWithRows:(uint64_t)rows columns:(uint64_t)cols;

#pragma mark Accessors

@property(readonly,assign) uint64_t rows;
@property(readonly,assign) uint64_t columns;
@property(readonly,assign) SMUGRealDoubleVector *underlyingVector;

- (double *)components;

- (void)setComponent:(double)c atRow:(uint64_t)row column:(uint64_t)col;
- (double)componentAtRow:(uint64_t)row column:(uint64_t)col;

#pragma mark Indexed Accessors

- (id)objectAtIndexedSubscript:(NSUInteger)index;

#pragma mark Math Operations

- (SMUGRealDoubleVector*)realDoubleVectorMultipliedByVector:(SMUGRealDoubleVector*)inVector;
- (SMUGRealDoubleMatrix*)realDoubleMatrixMultipliedByMatrix:(SMUGRealDoubleMatrix*)inMatrix;
- (void)pointwiseMultiplyBy:(SMUGRealDoubleMatrix *)inMatrix;
- (void)add:(SMUGRealDoubleMatrix *)inMatrix;
- (void)subtract:(SMUGRealDoubleMatrix *)inMatrix;

- (SMUGRealDoubleMatrix *)transposedCopy;

- (SMUGRealDoubleMatrix *)inverse;
- (double)determinant;

#pragma mark Extended Math

- (SMUGRealDoubleMatrix *)repmatCopyWithRows:(uint64_t)inRows columns:(uint64_t)inColumns;

@end
