#import <Foundation/Foundation.h>
#import "complex.h"

@class SMUGRealVector;
@protocol SMUGFMPlugInComplexVector;

@interface SMUGComplexVector : NSObject
{
    void *mBytes;
    uint64_t mByteLength;
    BOOL mFreeWhenDone;
}

#pragma mark Initializers
- (id)initWithLength:(uint64_t)N;

#pragma mark Convenience Constructors
+ (id)complexVectorWithLength:(uint64_t)N;
+ (id)complexVectorWithRealVector:(SMUGRealVector*)v;
+ (id)complexVectorWithAbs:(SMUGRealVector*)mag phase:(SMUGRealVector*)phase;

#pragma mark Accessors
- (uint64_t)length;
- (complex float*)components;
- (void)setComponent:(complex float)f atIndex:(uint64_t)index;
- (complex float)componentAtIndex:(uint64_t)index;

#pragma mark Resizing
- (void)setLength:(uint64_t)N;

#pragma mark Range Operations
- (SMUGComplexVector*)complexVectorInRange:(NSRange)range;
- (void)replaceComponentsInRange:(NSRange)range withComplexFloats:(complex float*)data;
- (void)replaceComponentsInRange:(NSRange)range withComplexVector:(SMUGComplexVector*)v;

#pragma mark Phase
- (SMUGRealVector*)phaseInRadians;
- (SMUGRealVector*)phaseInDegrees;

#pragma mark Complex -> Real Operations
- (SMUGRealVector*)real;
- (SMUGRealVector*)imag;
- (SMUGRealVector*)abs;

#pragma mark Basic Math
- (void)add:(SMUGRealVector*)x;
- (void)complexAdd:(SMUGComplexVector*)x;
- (void)complexSubtract:(SMUGComplexVector*)y;
- (void)scaleBy:(float)scalar;
- (void)complexScaleBy:(complex float)scalar;
- (void)multiplyBy:(SMUGRealVector*)x;
- (void)complexMultiplyBy:(SMUGComplexVector*)x;
- (void)divideBy:(SMUGRealVector*)x;
- (void)complexDivideBy:(SMUGComplexVector*)x;

#pragma mark Intermediate Math
- (void)square;
- (void)sqrt;
- (void)invert;
- (void)exp;
- (void)conjugate;

#pragma mark Combinations of Vectors

+ (SMUGComplexVector*)average:(NSArray*)vectors;
+ (SMUGComplexVector*)RMSAverageOfVectors:(NSArray*)vectors;

@end
