/*
 *  SVocalRemover.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 3/26/11
 *  Copyright 2011 SuperMegaUltraGroovy. All rights reserved.
 *
 */
 
#if !defined( __SVocalRemover_h__ )
#define __SVocalRemover_h__

#include <stdbool.h>
#include <stdint.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSVocalRemover * SVocalRemoverRef;

SVocalRemoverRef SVocalRemoverCreate( uint32_t inSampleRate, uint32_t inNumberChannels, uint32_t inBufferSizeFrames );
void SVocalRemoverDestroy( SVocalRemoverRef inVocalRemover );

void SVocalRemoverSetLowFrequency( SVocalRemoverRef, double inLowFrequency );
double SVocalRemoverLowFrequency( SVocalRemoverRef );

void SVocalRemoverSetHighFrequency( SVocalRemoverRef, double inHighFrequency );
double SVocalRemoverHighFrequency( SVocalRemoverRef );

void SVocalRemoverSetBypass( SVocalRemoverRef, bool inBypass );
bool SVocalRemoverIsBypassed( SVocalRemoverRef );

uint32_t SVocalRemoverChannelCount( SVocalRemoverRef );
uint32_t SVocalRemoverLatency( SVocalRemoverRef );

uint32_t SVocalRemoverSpectrumLength( SVocalRemoverRef );
int32_t SVocalRemoverGetSpectrum( SVocalRemoverRef self, float **outSpectrum, uint32_t inLength );

void SVocalRemoverReset( SVocalRemoverRef );

int32_t SVocalRemoverProcess( SVocalRemoverRef, float **inSignal, int32_t inSignalLength, float **outSignal, int32_t outSignalLength );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SVocalRemover_h__
