/*
 *  SQueueableAudioNotification.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 7/9/12.
 *  Copyright 2012 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SQueueableAudioNotification_h__ )
#define __SQueueableAudioNotification_h__

#include <CoreAudio/CoreAudioTypes.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSQueueableAudioNotification *SQueueableAudioNotificationRef;
typedef void (^SQueueableAudioNotificationProcessBlock)(SQueueableAudioNotificationRef);

SQueueableAudioNotificationRef SQueueableAudioNotificationCreate( SQueueableAudioNotificationProcessBlock inProcessBlock );
void SQueueableAudioNotificationDestroy( SQueueableAudioNotificationRef );

SQueueableAudioNotificationProcessBlock SQueueableAudioNotificationProcessingBlock( SQueueableAudioNotificationRef self );

Boolean SQueueableAudioNotificationInProgress( SQueueableAudioNotificationRef inQueueableAudioNotification );
void SQueueableAudioNotificationSetInProgress( SQueueableAudioNotificationRef inQueueableAudioNotification, Boolean inInProgress );

SQueueableAudioNotificationRef SQueueableAudioNotificationNext( SQueueableAudioNotificationRef inQueueableAudioNotification );
void SQueueableAudioNotificationSetNext( SQueueableAudioNotificationRef inQueueableAudioNotification, SQueueableAudioNotificationRef inNextNotification );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SQueueableAudioNotification_h__
