/*
 *  SQueueableAudioBuffer.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 8/30/10.
 *  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SQueueableAudioBuffer_h__ )
#define __SQueueableAudioBuffer_h__

#include "SAudioBuffer.h"

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSQueueableAudioBuffer *SQueueableAudioBufferRef;
typedef void (^SQueueableAudioBufferProcessBlock)(SQueueableAudioBufferRef);

SQueueableAudioBufferRef SQueueableAudioBufferCreate( SQueueableAudioBufferProcessBlock inProcessBlock, UInt32 inNumberFrames, UInt32 inNumberChannels );
void SQueueableAudioBufferDestroy( SQueueableAudioBufferRef );

SQueueableAudioBufferProcessBlock SQueueableAudioBufferProcessingBlock( SQueueableAudioBufferRef self );

Boolean SQueueableAudioBufferInProgress( SQueueableAudioBufferRef inQueueableAudioBuffer );
void SQueueableAudioBufferSetInProgress( SQueueableAudioBufferRef inQueueableAudioBuffer, Boolean inInProgress );

SInt64 SQueueableAudioBufferFileStartFrame( SQueueableAudioBufferRef );
void SQueueableAudioBufferSetFileStartFrame( SQueueableAudioBufferRef, SInt64 inStartFrame );

Float64 SQueueableAudioBufferPlaybackRate( SQueueableAudioBufferRef );
void SQueueableAudioBufferSetPlaybackRate( SQueueableAudioBufferRef, Float64 inRate );

SQueueableAudioBufferRef SQueueableAudioBufferNext( SQueueableAudioBufferRef inQueueableAudioBuffer );
void SQueueableAudioBufferSetNext( SQueueableAudioBufferRef inQueueableAudioBuffer, SQueueableAudioBufferRef inNextBuffer );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SQueueableAudioBuffer_h__