//
//  SMono.h
//  SMUGAudio
//
//  Created by Christopher Liscio on 3/26/11.
//  Copyright 2011 SuperMegaUltraGroovy. All rights reserved.
//

#if !defined( __SMono_h__ )
#define __SMono_h__

#include <stdbool.h>
#include <stdint.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSMono * SMonoRef;

SMonoRef SMonoCreate( void );
void SMonoDestroy( SMonoRef inMono );

void SMonoSetPanAmount( SMonoRef, double inPanAmount );
double SMonoPanAmount ( SMonoRef );

void SMonoSetOutOfPhase( SMonoRef, bool );
bool SMonoOutOfPhase( SMonoRef );

int32_t SMonoProcess( SMonoRef, float **inSignal, int32_t inSignalLength, float **outSignal, int32_t outSignalLength );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SMono_h__
