//
//  OutputAudioUnit.h
//  TapeDeck
//
//  Created by Christopher Liscio on 4/7/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioToolbox/AudioToolbox.h>
#import <AudioUnit/AudioUnit.h>
#import "SAudioNotificationQueueWorker.h"

@class SMUGAudioStreamBasicDescription;
@class SMUGAudioDevice;
@class SMUGAudioBufferQueue;

@interface SMUGOutputAudioUnit : NSObject {
    SMUGAudioStreamBasicDescription *mStreamDescription;
    id mDelegate;
    AUGraph mGraph;
    AudioUnit mVarispeedUnit;
    AudioUnit mOutputUnit;
    AUNode mVarispeedNode;
    AUNode mOutputNode;
    
@public
    AudioSampleType *mPeakBuf;
    NSUInteger mPeakBufIndex;
    NSUInteger mPeakBufLength;
    NSInvocation *mOutputInvocation;
    SMUGAudioBufferQueue *mAudioBufferQueue;
    SQueueableAudioNotificationRef mAudioNotification;
    SAudioNotificationQueueWorkerRef mAudioNotificationQueueWorker;
    BOOL mDone;
}

@property (readonly,retain) SMUGAudioStreamBasicDescription *streamDescription;
@property (readwrite,assign) id delegate;

@property (readwrite,assign) CGFloat playbackRate;
@property (readwrite,retain) SMUGAudioBufferQueue *audioBufferQueue;

- (id)initWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd device:(SMUGAudioDevice*)device;

- (void)setEndOfStreamNotificationBlock:(SQueueableAudioNotificationProcessBlock)inBlock;

- (void)start;
- (void)stop;
- (BOOL)isRunning;

- (void)setPlaybackLevel:(CGFloat)level;

@end
