//
//  InputAudioUnit.h
//  TapeDeck
//
//  Created by Christopher Liscio on 4/7/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioUnit/AudioUnit.h>
#import "SMUGAudioUnit.h"

@class SMUGAudioStreamBasicDescription;
@class SMUGAudioBuffer;
@class SMUGAudioDevice;

typedef void (^SMUGInputAudioUnitProcessingBlock)(AudioUnitRenderActionFlags *ioActionFlags, const AudioTimeStamp *inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList *ioData );

@interface SMUGInputAudioUnit : SMUGAudioUnit {
    SMUGAudioBuffer *mInputAudioBuffer;
    SMUGAudioDevice *mDevice;
    NSArray *mChannels;
@public
    SMUGInputAudioUnitProcessingBlock mInputProcessingBlock;
}

- (id)initWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd device:(SMUGAudioDevice*)device channels:(NSArray*)inChannels;
- (id)initWithDevice:(SMUGAudioDevice*)device channels:(NSArray*)inChannels;

@property (readwrite,copy) SMUGInputAudioUnitProcessingBlock inputProcessingBlock;

@end
