//
//  AudioFileRecorder.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 11/30/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioToolbox/AudioToolbox.h>

@class SMUGInputAudioUnit;
@class SMUGAudioDevice;
@class SMUGExtendedAudioFile;
@class SMUGAudioStreamBasicDescription;
@class SMUGAudioFileWriter;

// AudioFileRecorder
//     A class that handles the recording of an audio stream to a file.  Basically you initialize it with a file to point at, and then start/stop the recording.  Once the recording is stopped, the file is considered written and no longer appendable.
@interface SMUGExtendedAudioFileRecorder : NSObject {
    SMUGInputAudioUnit *mInputAudioUnit;
    SMUGExtendedAudioFile *mRecordFile;
    SInt64 mCurrentFrame;
    id mDelegate;
    
    SMUGAudioFileWriter *mAudioFileWriter;
}

@property (readonly,retain) SMUGInputAudioUnit *inputAudioUnit;
@property (readonly,retain) SMUGExtendedAudioFile *recordFile;
@property (readwrite,assign) id delegate;
@property (readonly,assign) CGFloat currentTime;

// Record to the specified file, with the specified device, on the specified channel list. If inChannels is nil, the recording will happen on the default set of channels ([0 1] for stereo, [0] for mono).
- (id)initWithFile:(SMUGExtendedAudioFile*)file device:(SMUGAudioDevice*)device recordChannels:(NSArray*)inChannels;

- (void)startRecording;
- (void)stopRecording;

- (BOOL)isFileRecording;

@end
