//
//  AudioFilePlayer.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/2/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioToolbox/AudioToolbox.h>

@class SMUGAudioStreamBasicDescription;
@class SMUGOutputAudioUnit;
@class SMUGExtendedAudioFile;
@class SMUGAudioFileReader;
@class SMUGAudioDevice;

@interface SMUGExtendedAudioFilePlayer : NSObject {
    SMUGExtendedAudioFile *mAudioFile;
    SMUGAudioStreamBasicDescription *mStreamDescription;
    SMUGOutputAudioUnit *mOutputAudioUnit;
    BOOL mDone;
    BOOL mLooping;
    id mDelegate;
    CGFloat mCurrentTime;
    UInt64 mStartHostTime;

    SMUGAudioFileReader *mFileReader;
}

@property (readonly,retain) SMUGOutputAudioUnit *outputAudioUnit;
@property (readwrite,assign) id delegate;
@property (readwrite,assign) BOOL looping;
@property (readwrite,assign) SInt64 currentFrame;
@property (readwrite,assign) CGFloat currentTime;
@property (readonly,assign) CGFloat maxTime;

- (id)initWithAudioFile:(SMUGExtendedAudioFile*)audioFile device:(SMUGAudioDevice*)device;
- (id)initWithFilename:(NSString*)filename device:(SMUGAudioDevice*)device DEPRECATED_ATTRIBUTE;
- (id)initWithFileURL:(NSURL*)url device:(SMUGAudioDevice*)device;
- (void)startFilePlaying;
- (void)stopFilePlaying;
- (BOOL)isFilePlaying;

- (void)setPlaybackSpeed:(CGFloat)speed;
- (CGFloat)playbackSpeed;

- (void)setPlaybackLevel:(CGFloat)level;
- (void)setPlaybackVolume:(CGFloat)volume; // set in dB

@end
