//
//  AudioFile.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/3/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

@class SMUGAudioStreamBasicDescription;
@class SMUGAudioQueue;
@class SMUGAudioDevice;

@interface SMUGExtendedAudioFile : NSObject {
    ExtAudioFileRef mAudioFile;
    SMUGAudioStreamBasicDescription *mPreferredClientDataFormat;
    BOOL mReverse;
    NSURL* mUrl;
}

@property (readonly,assign) ExtAudioFileRef audioFile;
@property (readonly,copy) NSURL *url;
@property (readonly,assign) NSUInteger bitrate;
@property (readwrite,assign) BOOL reverse;
#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
@property (readwrite,assign) BOOL prefersHardwareEncoder;
#endif

#if (!TARGET_OS_IPHONE)
- (id)initForRecordingWithFilename:(NSString*)filename streamDescription:(SMUGAudioStreamBasicDescription*)sd bitrate:(NSUInteger)br audioDevice:(SMUGAudioDevice*)device DEPRECATED_ATTRIBUTE;
- (id)initForRecordingWithFileURL:(NSURL*)url streamDescription:(SMUGAudioStreamBasicDescription*)sd bitrate:(NSUInteger)br audioDevice:(SMUGAudioDevice*)device;
#endif // (!TARGET_OS_IPHONE)

- (id)initForPlaybackWithFilename:(NSString*)filename options:(NSDictionary*)options DEPRECATED_ATTRIBUTE;
- (id)initForPlaybackWithFilename:(NSString*)filename DEPRECATED_ATTRIBUTE;

- (id)initForPlaybackWithFileURL:(NSURL*)url options:(NSDictionary*)options;
- (id)initForPlaybackWithFileURL:(NSURL*)url;

- (SMUGAudioStreamBasicDescription*)streamDescription;
- (UInt32)maxPacketSize;

- (Float64)estimatedDuration;
- (SInt64)frameCount;

- (void)seekToFrame:(SInt64)frame;
- (void)closeFile;

@end

#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
// Indicates that the file should be read using the hardware AAC encoder.
//      Type: NSNumber (BOOL)
extern NSString *kSMUGExtendedAudioFilePrefersHardwareEncoderKey;
#endif //__IPHONE_OS_VERSION_MIN_REQUIRED
extern NSString *kSMUGExtendedAudioFileClientDataFormatKey;