//
//  SMUGAudioUnit.h
//  TapeDeck
//
//  Created by Christopher Liscio on 4/8/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioUnit/AudioUnit.h>

@class SMUGAudioStreamBasicDescription;

@interface SMUGAudioUnit : NSObject {
    AudioUnit mAudioUnit;
    SMUGAudioStreamBasicDescription *mStreamDescription;
    id mDelegate;
}

- (id)initWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd;

@property (readonly,retain) SMUGAudioStreamBasicDescription *streamDescription;
@property (readwrite,assign) AudioUnit audioUnit;
@property (readwrite,assign) id delegate;

+ (AudioUnit)openDefaultComponentType:(OSType)type subType:(OSType)subType;

- (void)start;
- (void)stop;
- (void)installPropertyListener;

- (BOOL)isRunning;

- (void)setProperty:(AudioUnitPropertyID)inID scope:(AudioUnitScope)inScope element:(AudioUnitElement)inElement data:(void*)inData size:(UInt32)inSize;
- (void)audioUnitInitialize;
- (void)audioUnitUninitialize;

@end

extern NSString *kAudioUnitDidStartNotification;
extern NSString *kAudioUnitDidStopNotification;
