//
//  StreamDescription.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/2/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>

@interface SMUGAudioStreamBasicDescription : NSObject {
    AudioStreamBasicDescription mASBD;
}

@property (readwrite,assign) UInt32 formatID;
@property (readwrite,assign) UInt32 bitsPerChannel;
@property (readwrite,assign) UInt32 channelsPerFrame;
@property (readwrite,assign) UInt32 formatFlags;
@property (readwrite,assign) UInt32 bytesPerPacket;
@property (readwrite,assign) UInt32 bytesPerFrame;
@property (readwrite,assign) UInt32 framesPerPacket;
@property (readwrite,assign) Float64 sampleRate;
@property (readwrite,assign) BOOL isInterleaved;
@property (readonly,assign) BOOL isNativeFormat;
@property (readonly,assign) BOOL isLinearPCMFormat;
@property (readonly,assign) BOOL isCanonicalFormat;
@property(readonly,assign) AudioStreamBasicDescription audioStreamBasicDescription;

- (id)initWithAudioStreamBasicDescription:(AudioStreamBasicDescription)theDescription;
+ (SMUGAudioStreamBasicDescription*)streamDescriptionWithAudioStreamBasicDescription:(AudioStreamBasicDescription)theDescription;
+ (SMUGAudioStreamBasicDescription*)streamDescription;
+ (SMUGAudioStreamBasicDescription*)nativeStreamDescription;
+ (SMUGAudioStreamBasicDescription*)pcm16StreamDescription;
+ (SMUGAudioStreamBasicDescription*)alacStreamDescription;
+ (SMUGAudioStreamBasicDescription*)aacStreamDescription;

- (void)setDefaultInputDeviceSampleRate __OSX_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_NA );
- (void)setDefaultOutputDeviceSampleRate __OSX_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_NA );

- (void)setNativeFormat;

@end
