//
//  AudioQueue.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/2/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioToolbox/AudioToolbox.h>

extern NSString *kAudioQueueDidStartNotification;
extern NSString *kAudioQueueDidStopNotification;

@class SMUGAudioStreamBasicDescription;

@interface SMUGAudioQueue : NSObject {
    AudioQueueRef   mQueue;
    BOOL            mRunning;
    NSInvocation    *mInInvocation;
    NSInvocation    *mOutInvocation;
    SMUGAudioStreamBasicDescription *mStreamDescription;
    id mDelegate;
}

@property(readwrite,retain) SMUGAudioStreamBasicDescription *streamDescription;
@property(readwrite,assign) AudioQueueRef queue;
@property(readwrite,assign) BOOL running;
@property(readwrite,assign) id delegate;

- (id)initWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd;
- (id)initOutputQueueWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd;
- (id)initInputQueueWithStreamDescription:(SMUGAudioStreamBasicDescription*)sd;

- (void)setOutputQueueBufferHandler:(id)target selector:(SEL)sel userData:(void*)ud;
- (void)setInputQueueBufferHandler:(id)target selector:(SEL)sel userData:(void*)ud;

- (void)setMagicCookie:(char*)cookie withSize:(UInt32)size;

- (void)startQueue;
- (void)stopQueue;
- (void)pauseQueue;
- (void)stopQueueImmediately;
- (AudioQueueBufferRef)allocateBufferWithSize:(UInt32)size;
- (void)enqueueBuffer:(AudioQueueBufferRef)buffer withPacketDescs:(const AudioStreamPacketDescription*)packetDescs count:(UInt32)count;

- (CGFloat)sampleTimeInMilliseconds;

@end
