//
//  SMUGAudioInputMeter.h
//  TapeDeck
//
//  Created by Christopher Liscio on 4/7/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioUnit/AudioUnit.h>

@class SMUGInputAudioUnit;
@class SMUGAudioDevice;

@interface SMUGAudioInputMeter : NSObject {
    SMUGInputAudioUnit *mInputAudioUnit;
    AudioSampleType **mPeakBuf;
    NSUInteger mPeakBufIndex;
    NSUInteger mPeakBufLength;    
    CGFloat mLevels[2];
}

- (id)initWithDevice:(SMUGAudioDevice*)inDevice channels:(NSArray*)inChannels;

// Returns a pointer to a CGFloat[2] with the current levels
@property (readonly,assign) CGFloat* levels;

- (void)start;
- (void)stop;

@end
