//
//  SMUGAudioHardware.h
//  TapeDeck
//
//  Created by Christopher Liscio on 5/27/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <CoreAudio/CoreAudio.h>

@class SMUGAudioDevice;

@interface SMUGAudioHardware : NSObject {
    NSMutableArray *mDelegates;
    AudioDeviceID mDefaultInputDevice;
}

+ (id)sharedInstance;

- (void)addDelegate:(id)delegate;
- (void)removeDelegate:(id)delegate;

+ (AudioDeviceID)deviceIDForDeviceUID:(NSString*)inDeviceUID;

+ (AudioDeviceID)defaultInputDeviceID;
+ (SMUGAudioDevice*)defaultInputDevice;

+ (AudioDeviceID)defaultOutputDeviceID;
+ (SMUGAudioDevice*)defaultOutputDevice;

// Returns an array of NSNumbers filled with AudioDeviceIDs
+ (NSArray*)allDeviceIDs;

// Returns an array of SMUGAudioDevice objects which can record
+ (NSArray*)allDevices;
+ (NSArray*)playbackDevices;
+ (NSArray*)recordingDevices;
+ (NSArray*)stereoRecordingDevices;

- (UInt32)numberOfChannelsForDevice:(AudioDeviceID)audioDevice direction:(UInt32)direction;
- (UInt32)numberOfChannelsForDefaultInputDevice;

@end

@interface NSObject(SMUGAudioHardwareDelegate)
- (void)deviceListDidChange;
- (void)defaultInputDeviceDidChange;
- (void)defaultInputDeviceSampleRateDidChange;
@end
