// SMUGAudioFileReader.h
// Author: Chris Liscio
// Copyright (c) 2008 SuperMegaUltraGroovy

#import <Foundation/Foundation.h>
#import "SMUGAudioFileStreamer.h"

@interface SMUGAudioFileReader : SMUGAudioFileStreamer {
@public
    SInt64 mCurrentFrame;
    NSRange mLoopRange;
    BOOL mLooping;
}

@property (readwrite,assign) SInt64 currentFrame;
@property (readwrite,assign) NSRange loopRange;
@property (readwrite,assign,getter=isLooping) BOOL looping;
@property (readwrite,assign) BOOL reverse;

@end

#if defined(__cplusplus)
extern "C" {
#endif // __cplusplus

SInt64 SMUGAudioFileReaderGetCurrentFrame( SMUGAudioFileReader * );

#if defined(__cplusplus)
}
#endif // __cplusplus