//
//  AudioFile.h
//  AudioQueueTools
//
//  Created by Christopher Liscio on 12/3/07.
//  Copyright 2007 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AudioToolbox/AudioToolbox.h>

@class SMUGAudioStreamBasicDescription;
@class SMUGAudioQueue;

@interface SMUGAudioFile : NSObject {
    ExtAudioFileRef mAudioFile;
    BOOL mReverse;
    NSURL* mUrl;
}

@property (readonly,assign) ExtAudioFileRef audioFile;
@property (readonly,copy) NSURL *url;
@property (readonly,assign) NSUInteger bitrate;
@property (readwrite,assign) BOOL reverse;

- (id)initForRecordingWithFilename:(NSString*)filename streamDescription:(SMUGAudioStreamBasicDescription*)sd bitrate:(NSUInteger)br DEPRECATED_ATTRIBUTE;
- (id)initForPlaybackWithFilename:(NSString*)filename DEPRECATED_ATTRIBUTE;

- (id)initForRecordingWithFileURL:(NSURL*)url streamDescription:(SMUGAudioStreamBasicDescription*)sd bitrate:(NSUInteger)br;
- (id)initForPlaybackWithFileURL:(NSURL*)url;

- (SMUGAudioStreamBasicDescription*)streamDescription;
- (UInt32)maxPacketSize;

- (Float64)estimatedDuration;
- (SInt64)frameCount;

- (void)closeFile;

@end
