//
//  SMUGAudioDevice.h
//  SMUGAudio
//
//  Created by Christopher Liscio on 5/7/09.
//  Copyright 2009 SuperMegaUltraGroovy. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <CoreAudio/CoreAudio.h>

typedef enum {
    kSMUGAudioDeviceOutputDirection = 0,
    kSMUGAudioDeviceInputDirection,
} SMUGAudioDeviceDirection;

@class SMUGAudioStreamBasicDescription;

@interface SMUGAudioDevice : NSObject {
    AudioDeviceID mDeviceID;
}

- (id)initWithDeviceID:(AudioDeviceID)deviceID;
- (id)initWithDeviceUID:(NSString*)deviceUID;

@property (readonly,assign) AudioDeviceID deviceID;

- (NSString*)deviceUID;
- (NSString*)deviceName;

- (UInt32)numberOfChannelsForDirection:(SMUGAudioDeviceDirection)direction;
- (UInt32)numberOfRecordChannels;
- (UInt32)numberOfPlaybackChannels;

- (SMUGAudioStreamBasicDescription*)deviceNativeRecordStreamDescription;
- (SMUGAudioStreamBasicDescription*)deviceNativePlaybackStreamDescription;

- (BOOL)canPlayback;
- (BOOL)canRecord;
- (BOOL)canRecordStereo;

@end