// SMUGAudioBufferQueue.h
// Author: Chris Liscio
// Copyright (c) 2008 SuperMegaUltraGroovy

#import <Foundation/Foundation.h>
#import <CoreAudio/CoreAudioTypes.h>
#import "SQueueableAudioBuffer.h"
#import "SAudioBufferQueueWorker.h"

@class SMUGAudioStreamBasicDescription;
@class SMUGAudioBufferQueueWorker;

@interface SMUGAudioBufferQueue : NSObject

@property (readonly,assign) BOOL endOfStream;

- (id)initWithBufferCount:(UInt32)bufferCount numFrames:(UInt32)bufferSizeFrames streamDescription:(SMUGAudioStreamBasicDescription*)sd;

- (void)prime;
- (void)flush;

// Subclass will read from an audio file, generate sound, or whatever. This routine is called from a different process.
- (void)processBuffer:(SQueueableAudioBufferRef)b;

- (void)teardownWorkerThread;

- (void)startWorker;
- (void)stopWorker;

@end

#if defined(__cplusplus)
extern "C" {
#endif

void SMUGAudioBufferQueueCopyInto( SMUGAudioBufferQueue*, AudioBufferList *abl, UInt32 *ioNumFrames );
void SMUGAudioBufferQueueCopyFrom( SMUGAudioBufferQueue*, AudioBufferList *abl, UInt32 inNumberFrames );
BOOL SMUGAudioBufferQueueReachedEndOfStream( SMUGAudioBufferQueue* );
UInt64 SMUGAudioBufferQueueCurrentFrame( SMUGAudioBufferQueue *SELF );

#if defined(__cplusplus)
}
#endif