//
//  SMUGAudioBufferListUtils.h
//  TapeDeck
//
//  Created by Christopher Liscio on 6/18/08.
//  Copyright 2008 SuperMegaUltraGroovy. All rights reserved.
//

#import <CoreAudio/CoreAudioTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SMUGAudioBufferListCreateDeinterleavedFloats( numChannels, numFrames ) SMUGAudioBufferListCreate( (numChannels), (numFrames), sizeof(float), NO )
#define SMUGAudioBufferListFrameCapacityFloats( abl ) SMUGAudioBufferListCapacityInFrames( (abl), sizeof(float) )
#define SMUGAudioBufferListSize( numBuffers ) ( sizeof(AudioBufferList) + ( sizeof(AudioBuffer) * ( (numBuffers) - 1 ) ) )

AudioBufferList *SMUGAudioBufferListCopy( AudioBufferList *src );
AudioBufferList *SMUGAudioBufferListCreate( UInt32 numChannels, UInt32 numFrames, UInt32 sampleSize, Boolean isInterleaved );
UInt32 SMUGAudioBufferListCapacityInFrames( AudioBufferList *abl, UInt32 sampleSize );
void SMUGAudioBufferListDestroy( AudioBufferList *abl );

#ifdef __cplusplus
} // extern "C"
#endif
