// SMUGAudioBuffer.h
// Author: Chris Liscio
// Copyright (c) 2008 SuperMegaUltraGroovy

#import <Foundation/Foundation.h>
#import <CoreAudio/CoreAudioTypes.h>

@interface SMUGAudioBuffer : NSObject {
    AudioBufferList *mAudioBufferList;
    UInt32 mByteSize;
    UInt32 mStartFrame;
    UInt32 mEndFrame;
    BOOL mEndOfStream;    
}

@property (readonly,assign) AudioBufferList *audioBufferList;

- (id)initWithNumberFrames:(UInt32)numFrames channels:(UInt32)channels;

@property (readwrite,assign) UInt32 endFrame;
@property (readwrite,assign) UInt32 startFrame;
@property (readonly,assign) UInt32 frameCount;
@property (readwrite,assign) BOOL endOfStream;

// Returns YES if the buffer is emptied and we're not at the end of the stream
- (BOOL)copyFramesIntoAudioBufferList:(AudioBufferList*)dest 
    bytesPerFrame:(UInt32)bytesPerFrame 
    framesProduced:(UInt32*)framesProduced
    framesRequired:(UInt32*)framesRequired;

// Returns YES if the buffer is filled
- (BOOL)copyFramesFromAudioBufferList:(AudioBufferList*)src 
    bytesPerFrame:(UInt32)bytesPerFrame 
    framesProduced:(UInt32*)framesProduced
    framesRequired:(UInt32*)framesRequired;

// Mark the audio buffer as empty (reset the buffer)
- (void)setEmpty;

@end
