//
//  SBufferQueue.h
//  SMUGAudio
//
//  Created by Christopher Liscio on 3/26/11.
//  Copyright 2011 SuperMegaUltraGroovy. All rights reserved.
//

#if !defined( __SBufferQueue_h__ )
#define __SBufferQueue_h__

#include <stdint.h>
#include "SMUGAudio.h"

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSBufferQueue * SBufferQueueRef;

SBufferQueueRef SBufferQueueCreate( uint32_t inLength );
void SBufferQueueDestroy( SBufferQueueRef inBufferQueue );

void SBufferQueueAppend( SBufferQueueRef, const SAudioSampleType *inBuffer, uint64_t inLength );
void SBufferQueueRead( SBufferQueueRef, SAudioSampleType *inDestination, uint64_t inLength );
void SBufferQueueAdvance( SBufferQueueRef, uint64_t inLength );
void SBufferQueueClear( SBufferQueueRef );

uint64_t SBufferQueueLength( SBufferQueueRef );
uint64_t SBufferQueueUsed( SBufferQueueRef );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SBufferQueue_h__
