/*
 *  SAudioNotificationQueueWorker.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 7/9/12.
 *  Copyright 2012 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SAudioNotificationQueueWorker_h__ )
#define  __SAudioNotificationQueueWorker_h__

#include <CoreFoundation/CoreFoundation.h>
#include "SQueueableAudioNotification.h"

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSAudioNotificationQueueWorker *SAudioNotificationQueueWorkerRef;

SAudioNotificationQueueWorkerRef SAudioNotificationQueueWorkerCreate( void );
void SAudioNotificationQueueWorkerDestroy( SAudioNotificationQueueWorkerRef );

void SAudioNotificationQueueWorkerStart( SAudioNotificationQueueWorkerRef );
void SAudioNotificationQueueWorkerStop( SAudioNotificationQueueWorkerRef );
void SAudioNotificationQueueWorkerTeardown( SAudioNotificationQueueWorkerRef );

void SAudioNotificationQueueWorkerAddNotification( SAudioNotificationQueueWorkerRef, SQueueableAudioNotificationRef inNotification );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SAudioNotificationQueueWorker_h__
