/*
 *  SAudioBufferQueueWorker.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 8/31/10.
 *  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SAudioBufferQueueWorker_h__ )
#define  __SAudioBufferQueueWorker_h__

#include <CoreFoundation/CoreFoundation.h>
#include "SQueueableAudioBuffer.h"

typedef struct OpaqueSAudioBufferQueueWorker *SAudioBufferQueueWorkerRef;

SAudioBufferQueueWorkerRef SAudioBufferQueueWorkerCreate( void );
void SAudioBufferQueueWorkerDestroy( SAudioBufferQueueWorkerRef );

void SAudioBufferQueueWorkerStart( SAudioBufferQueueWorkerRef );
void SAudioBufferQueueWorkerStop( SAudioBufferQueueWorkerRef );
void SAudioBufferQueueWorkerTeardown( SAudioBufferQueueWorkerRef );

void SAudioBufferQueueWorkerAddBuffer( SAudioBufferQueueWorkerRef, SQueueableAudioBufferRef inBuffer );

#endif // __SAudioBufferQueueWorker_h__