/*
 *  SAudioBuffer.h
 *  SMUGAudio
 *
 *  Created by Christopher Liscio on 8/30/10.
 *  Copyright 2010 SuperMegaUltraGroovy. All rights reserved.
 *
 */

#if !defined( __SAudioBuffer_h__ )
#define __SAudioBuffer_h__

#include <CoreAudio/CoreAudioTypes.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct OpaqueSAudioBuffer * SAudioBufferRef;

SAudioBufferRef SAudioBufferCreate( UInt32 inNumberFrames, UInt32 inNumberChannels );
void SAudioBufferDestroy( SAudioBufferRef inAudioBuffer );

void SAudioBufferSetEndFrame( SAudioBufferRef inAudioBuffer, UInt32 inEndFrame );
UInt32 SAudioBufferEndFrame( SAudioBufferRef inAudioBuffer );

void SAudioBufferSetStartFrame( SAudioBufferRef inAudioBuffer, UInt32 inStartFrame );
UInt32 SAudioBufferStartFrame( SAudioBufferRef inAudioBuffer );

AudioBufferList *SAudioBufferAudioBufferList( SAudioBufferRef );

UInt32 SAudioBufferFrameCount( SAudioBufferRef inAudioBuffer );

Boolean SAudioBufferReachedEndOfStream( SAudioBufferRef );
void SAudioBufferSetReachedEndOfStream( SAudioBufferRef, Boolean );

void SAudioBufferSetEmpty( SAudioBufferRef inAudioBuffer );

/* Copy from the buffer to the passed-in audio buffer list. Returns YES if the buffer is filled. */
Boolean SAudioBufferCopyInto( SAudioBufferRef inAudioBuffer, AudioBufferList *inAudioBufferList, UInt32 inBytesPerFrame, UInt32 *outFramesProduced, UInt32 *ioFramesRequired );

/* Copy from the passed-in audio buffer list into the buffer. Returns YES if the buffer is filled. */
Boolean SAudioBufferCopyFrom( SAudioBufferRef inAudioBuffer, AudioBufferList *inAudioBufferList, UInt32 inBytesPerFrame, UInt32 *outFramesProduced, UInt32 *ioFramesRequired );

#if defined(__cplusplus)
} // extern "C"
#endif

#endif // __SAudioBuffer_h__